/* $Id: cpl_image_io.h,v 1.72 2010/11/11 09:23:18 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2010/11/11 09:23:18 $
 * $Revision: 1.72 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#ifndef CPL_IMAGE_IO_H
#define CPL_IMAGE_IO_H

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _cpl_image_ cpl_image;

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "cpl_io.h"
#include "cpl_propertylist.h"
#include "cpl_mask.h"

#include <stdio.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                            Function prototypes
 -----------------------------------------------------------------------------*/

/* Image constructors */
cpl_image * cpl_image_new(int, int, cpl_type) CPL_ATTR_ALLOC;
cpl_image * cpl_image_wrap(int, int, cpl_type, void *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_wrap_double(int, int, double *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_wrap_float(int, int, float *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_wrap_int(int, int, int *) CPL_ATTR_ALLOC;

#ifdef _Complex_I
cpl_image * cpl_image_wrap_double_complex(int, int,
                                          double complex *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_wrap_float_complex(int, int,
                                         float complex *) CPL_ATTR_ALLOC;
#endif

cpl_image * cpl_image_load(const char *, cpl_type, int, int) CPL_ATTR_ALLOC;
cpl_image * cpl_image_load_window(const char *, cpl_type, int, int,
                                  int, int, int, int) CPL_ATTR_ALLOC;
cpl_image * cpl_image_new_from_mask(const cpl_mask *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_labelise_mask_create(const cpl_mask *,
                                           int *) CPL_ATTR_ALLOC;

/* Get functions */
cpl_type cpl_image_get_type(const cpl_image *);
int cpl_image_get_size_x(const cpl_image *);
int cpl_image_get_size_y(const cpl_image *);
double cpl_image_get(const cpl_image *, int, int, int *);

#ifdef _Complex_I
double complex cpl_image_get_complex(const cpl_image *, int, int, int *);
cpl_error_code cpl_image_set_complex(cpl_image *, int, int, double complex);
#endif

      cpl_mask * cpl_image_unset_bpm(cpl_image *);
      cpl_mask * cpl_image_get_bpm(cpl_image *);
const cpl_mask * cpl_image_get_bpm_const(const cpl_image *);
      void * cpl_image_get_data(cpl_image *);
const void * cpl_image_get_data_const(const cpl_image *);
      double * cpl_image_get_data_double(cpl_image *);
const double * cpl_image_get_data_double_const(const cpl_image *);
      float * cpl_image_get_data_float(cpl_image *);
const float * cpl_image_get_data_float_const(const cpl_image *);
      int * cpl_image_get_data_int(cpl_image *);
const int * cpl_image_get_data_int_const(const cpl_image *);
#ifdef _Complex_I
      double complex * cpl_image_get_data_double_complex(cpl_image *);
const double complex * cpl_image_get_data_double_complex_const(const cpl_image *);
      float complex * cpl_image_get_data_float_complex(cpl_image *);
const float complex * cpl_image_get_data_float_complex_const(const cpl_image *);
#endif

/* Set functions */
cpl_error_code cpl_image_set(cpl_image *, int, int, double);
cpl_error_code cpl_image_fill_rejected(cpl_image *, double);

/* Image destructor */
void cpl_image_delete(cpl_image *);
void * cpl_image_unwrap(cpl_image *);

/* Debugging functions */
cpl_error_code cpl_image_dump_structure(const cpl_image *, FILE *);
cpl_error_code cpl_image_dump_window(const cpl_image *, int, int, int, int,
                                     FILE *);

/* Others */
cpl_image * cpl_image_duplicate(const cpl_image *) CPL_ATTR_ALLOC;
cpl_image * cpl_image_cast(const cpl_image *, cpl_type) CPL_ATTR_ALLOC;

/* Saving function */
cpl_error_code cpl_image_save(const cpl_image *, const char *, cpl_type_bpp,
                              const cpl_propertylist *, unsigned);

CPL_END_DECLS

#endif 
