#! /bin/bash
#
# console-log   init script for console-log
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DESC="console-log"
LOGPAGER="/usr/share/console-log/logpager"
PIDFILEDEFDIR="/var/run/console-log"
CONFIGFILE="/etc/console-log.conf"

set -e

# WARNING! The pager is run as root. /usr/share/console-log/logpager is a
# wrapper for less that configures less in a secure way to not allow shell
# escapes. If you have extended the pager wrapper to support other pagers,
# please submit your patches via the BTS.

start_pager()
{
TTY="$1"
CHVT="$2"
FILE="$3"
USER="$4"
GROUP="$5"
PAGER="$6"
LOCSCRIPT="$7"

if echo $TTY | grep "[[:digit:]]\+" >/dev/null; then
  PIDFILEDIR="$PIDFILEDEFDIR"
  DAEMONUSER=""
  if [ -n "$USER" ]; then
    DAEMONUSER="--user $USER"
    mkdir -p $PIDFILEDEFDIR/$USER
    chown $USER $PIDFILEDEFDIR/$USER
    PIDFILEDIR="$PIDFILEDEFDIR/$USER"
    if [ -n "$GROUP" ]; then
      DAEMONUSER="$DAEMONUSER.$GROUP"
    fi
  fi
  if [ -f $FILE ]; then
    FILENAME="$TTY-${FILE//\//_-_}"
    if [ -x "$LOCSCRIPT" ]; then
      . $LOCSCRIPT $FILE
    fi
    if [ -z "$PAGER" ]; then
    	PAGER="/usr/share/console-log/logpager -- +F $FILE"
    fi
    openvt -f -c $TTY -- \
	daemon --foreground --respawn --attempts=20 --delay=10 \
             --name=$FILENAME --pidfile=$PIDFILEDIR/$FILENAME \
             $DAEMONUSER $PAGER
    if [ -f /etc/console.noblank ]; then
      setterm -blank 0 > /dev/tty$TTY
    fi
    [ "$CHVT" == "yes" ] && chvt $TTY
    echo -n "$FILE. "
  else
    echo "W: $FILE does not exist."
  fi
else
  echo "E: illegal tty $TTY."
  exit 1
fi
}

do_start()
{
mkdir -p $PIDFILEDEFDIR
cd $PIDFILEDEFDIR
while true; do
  # || true in the unset statements is necessary for woody
  unset tty || true
  chvt="no"
  unset file || true
  user="nobody"
  unset group || true
  unset locscript || true
  unset pager || true
  COUNTER=""
  ELINE=0
  while read KEY VALUE; do
    case "$KEY" in
      "#" | \#* )
	continue
        ;; # comment
      "" )
        ELINE=1
        break
        ;;
      tty|chvt|file|user|group|pager|locscript)
        eval $KEY=\"$VALUE\"
        COUNTER=".$COUNTER"
        ;;
      *)
        echo >&2 "ERR: illegal key $KEY"
	exit 1
	;;
    esac
  done
  # invoke pager if we have read parameters
  [ -n "$COUNTER" ] && start_pager $tty $chvt $file $user "$group" "$pager" $locscript
  # break out of loop if eof
  # if we get here without eof, then ELINE==1
  [ "$ELINE" != "1" ] && break
done < $CONFIGFILE
}

do_something()
{
	ACTION="$1"
	if ! [ -d $PIDFILEDEFDIR ]; then
	  echo "[$PIDFILEDEFDIR not found] done."
	  exit 0
	fi
	cd $PIDFILEDEFDIR
	for PIDPATH in `find . -type f -maxdepth 2`; do
	  FILENAME=`echo $PIDPATH | sed -n 's/.*\/\(.*\)/\1/p'`
	  PIDFILEDIR=`echo $PIDPATH | sed -n 's/^.*\/\(.*\)\/.*/\1/p'`
	  if [ -z "$PIDFILEDIR" ]; then
	    USER=""
	    PIDFILEDIR="$PWD"
	  else
	    USER="--user $PIDFILEDIR"
	    PIDFILEDIR="$PWD/$PIDFILEDIR"
	  fi
	  OUTPUT="${FILENAME#*-}"
	  OUTPUT="${OUTPUT//_-_//}"
	  TTY=${FILENAME%%-*}
          if daemon --running $USER --name=$FILENAME --pidfile=$PIDFILEDIR/$FILENAME; then
  	    if [ $ACTION == "stop" ]; then
	      daemon --stop $USER --name=$FILENAME --pidfile=$PIDFILEDIR/$FILENAME
	    fi
	    TERM=vt100 tput clear > /dev/tty$TTY
	  fi
	  if [ -d $PIDFILEDIR ]; then
	    rmdir --ignore-fail-on-non-empty $PIDFILEDIR
	  fi
	  
	  # BUGS: This creates weird output if the log file name contains
	  # the string "_-_". Go figure.
	  
	  echo -n "$OUTPUT. "
	done
}

case "$1" in
  start)
	echo -n "Starting $DESC: "
        do_start
	echo ""
	;;
  stop)
	echo -n "Stopping $DESC: "
  	do_something stop
	echo ""
	;;
  reload|force-reload|restart)
	echo -n "Restarting $DESC: "
	do_something stop
	sleep 1
	do_start
	echo ""
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	exit 1
	;;
esac

exit 0
