#! /usr/bin/env perl

my $protocol = $ARGV[0]; # ssl or gsi

$reqin = "requestinput.template";
$reqout = "requestinput";

($name, $pass, $uid, $gid, $quota, $comment, $gcos, $dir, $shell, $expire) = getpwuid($<);
print "My name is \"$name\"\n";

if($protocol eq "install") {
	system("make init");
	exit(0);
} elsif($protocol eq "cert") {

	$line = "";
	open(INPUT,"<$reqin") || die "Can't open request input file $!\n";
	open(OUT,">$reqout") || die "Can't open request output file $!\n";
	while(<INPUT>) {
		chomp($_);
		$line = $_;
		if( $line =~ /XXXX(.*)/) {
			$tmp = $name . $1;
			print OUT "$tmp\n";
		} else {
			print OUT "$line\n";
		}
	}
	close(INPUT);
	close(OUT);

	$genkey = "openssl genrsa -out user.key 1024";
	print "Get $name a key\n";
	$res = system("$genkey");
	if($res != 0) {
		die "Failed to get key for certificate request\n";
	}

	$genrequest = "openssl req -new -nodes -key user.key -out user.csr <requestinput";
	print "Generate certificate request for $name\n";
	$res = system("$genrequest");
	if($res != 0) {
		die "Failed to generate request\n";
	}

	$res = system("make sign");
	if($res != 0) {
		die "Failed to sign certificate request\n";
	}
} elsif($protocol eq "ssl") {
	$res = system("mkdir -p ssl_keys");
	if($res != 0) {
		die "Failed to make ssl_keys directory\n";
	}

	$res = system("mkdir -p ssl_keys/cadir");
	if($res != 0) {
		die "Failed to make ssl_keys directory\n";
	}

	if( -f "condor_mapfile" ) {
		$res = system("cp condor_mapfile ssl_keys");
		if($res != 0) {
			die "Failed to install condor_mapfile to ssl_keys directory\n";
		}
	}

	if( -f "user.key" ) {
		$res = system("cp user.key ssl_keys");
		if($res != 0) {
			die "Failed to install user.key to ssl_keys directory\n";
		}
	}

	if( -f "user.cert" ) {
		$res = system("cp user.cert ssl_keys");
		if($res != 0) {
			die "Failed to install user.cert to ssl_keys directory\n";
		}
	}

	if( -f "ca-cert.pem" ) {
		$res = system("cp ca-cert.pem ssl_keys");
		if($res != 0) {
			die "Failed to install ca-cert.pem to ssl_keys directory\n";
		}
	}

	$res = system("tar -zcvf x_lib_auth-ssl_keys.tgz ssl_keys");
	if($res != 0) {
		die "Failed to install ca-cert.pem to ssl_keys directory\n";
	}


} elsif($protocol eq "gsi") {
}

exit(0);
