import birdbath.*;
import condor.*;
import java.rmi.*;

import birdbath.Transaction;

public class SubmitRemoveTest1
extends AbstractScheddTestCase
{
    // Transaction that removes a job it didn't submit
    protected void runTest()
    throws Throwable
    {
        Transaction transaction1 = schedd.createTransaction();
        transaction1.begin(10);
        int cluster = transaction1.createCluster();
        int job = transaction1.createJob(cluster);
        transaction1.submit(cluster,
                            job,
                            "matt",
                            UniverseType.VANILLA,
                            "/bin/true",
                            null,
                            "FALSE",
                            null,
                            null);
        transaction1.commit();

        Transaction transaction2 = schedd.createTransaction();
        transaction2.begin(10);
        transaction2.closeSpool(cluster, job);
        transaction2.removeJob(cluster, job, "I can");
        transaction2.commit();

        try
        {
           schedd.getJobAd(cluster, job);
            fail("Remove didn't work");
        }
        catch (RemoteException exception)
        {
            // There was no job
        }
    }

    private static void check(Status status, String message)
    {
        assertTrue(message, status.getCode().equals(StatusCode.SUCCESS));
    }
}

