/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.IOUtils;
import condor.gahp.gt42.GSIUtils;
import java.io.File;
import org.ietf.jgss.GSSCredential;

public class RefreshProxyFromFileHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[1];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            return new CommandHandlerResponse("F", null);
        }
        GSSCredential gSSCredential = null;
        try {
            gSSCredential = GSIUtils.readCredentialFromFile(string);
        }
        catch (Exception exception) {
            System.err.println("Error reading credential: " + exception.getMessage());
            exception.printStackTrace(System.err);
            return new CommandHandlerResponse("F " + IOUtils.escapeWord(exception.getMessage()));
        }
        GSIUtils.setDefaultCredential(this.gahp, gSSCredential);
        return new CommandHandlerResponse("S");
    }
}

