/*
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla Communicator client code, released
# March 31, 1998.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998-1999
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Joachim Herb <joachim.herb@gmx.de>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
*/

if(!org) var org={};
if(!org.mozdev) org.mozdev={};
if(!org.mozdev.customizeHeaderToolbar) org.mozdev.customizeHeaderToolbar = {};

org.mozdev.customizeHeaderToolbar.pane = function(){
  var pub = {};

  const CHT_EXTENSION_UUID = "customizeheadertoolbar@mozdev.org";
  
  var CHTprefBranch = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService)
    .getBranch("extensions.CustomizeHeaderToolbar.");
  
  var vCHT={
    version: -1,
    firstrun: true,
    current: -1
  };
  
  pub.initCustomization = function() {
    var toolbox = document.getElementById("header-view-toolbox");
    toolbox.customizeDone = function(aEvent) {
      MailToolboxCustomizeDone(aEvent, "CustomizeHeaderToolbar");
      pub.CHTUpdateReplyButton();
      org.mozdev.customizeHeaderToolbar.messenger.saveToolboxData();
      document.getElementById("header-view-toolbox").removeAttribute("doCustomization");
    };
    var toolbarset = toolbox.ownerDocument.getElementById('customToolbars');
    toolbox.toolbarset = toolbarset;
  }
  
  pub.CHTOnLoadMsgHeaderPane = function() {
    gMessageListeners.push(CHTMessageListener);
    pub.initCustomization();
    if (vCHT.firstrun) {
      pub.CHTcheckFirstRun();
    }
    
    if (vCHT.firstrun || 
        (document.getElementById("header-view-toolbar") != null && 
         document.getElementById("header-view-toolbar").getAttribute("iconsize") != "small")) {
      pub.CHTSetDefaultButtons();
      vCHT.firstrun = false;
    }
  
  }
  
  pub.CHTOnUnloadMsgHeaderPane = function()
  {
    Components.classes["@mozilla.org/abmanager;1"]
              .getService(Components.interfaces.nsIAbManager)
              .removeAddressBookListener(coheAddressBookListener);
    
    removeEventListener('messagepane-loaded', org.mozdev.customizeHeaderToolbar.pane.CHTOnLoadMsgHeaderPane, true);
    removeEventListener('messagepane-unloaded', org.mozdev.customizeHeaderToolbar.pane.CHTOnUnloadMsgHeaderPane, true);
  }
    
  pub.CHTUpdateReplyButton = function() {
    let showReplyAll = IsReplyAllEnabled();
    let showReplyList = IsReplyListEnabled();
  
    // If we're in a news item, we should default to Reply.
    if (gFolderDisplay.selectedMessageIsNews)
    {
      showReplyAll = false;
      showReplyList = false;
    }
  
    let buttonToShow = "reply";
    if (showReplyList)
      buttonToShow = "replyList";
    else if (showReplyAll)
      buttonToShow = "replyAll";
  
    let smartReplyButton     = document.getElementById("hdrSmartReplyButton");
    let replyButton          = document.getElementById("hdrSReplyButton");
    let replyAllButton       = document.getElementById("hdrSReplyAllButton");
    let replyListButton      = document.getElementById("hdrSReplyListButton");
    let replyAllSubButton    = document.getElementById("hdrReplyAllSubButton");
    let replyAllSubButtonSep = document.getElementById("hdrReplyAllSubButtonSep");
    let replyToSenderButton  = document.getElementById("hdrReplyToSenderButton");
  
    if (smartReplyButton)
    {
      /* Cleanup after customization dialog */
      replyButton.removeAttribute("disabled");
      replyAllButton.removeAttribute("disabled");
      replyListButton.removeAttribute("disabled");
      
      replyButton.hidden = (buttonToShow != "reply");
      replyAllButton.hidden = (buttonToShow != "replyAll");
      replyListButton.hidden = (buttonToShow != "replyList");
      if (gFolderDisplay.selectedMessageIsNews)
      {
        // If it's a news item, show the ReplyAll sub-button and separator.
        replyAllSubButton.hidden = false;
        replyAllSubButtonSep.hidden = false;
       }
      else if (gFolderDisplay.selectedMessageIsFeed)
      {
        // otherwise, if it's an rss item, hide all the Reply buttons.
        replyButton.hidden = true;
        replyAllButton.hidden = true;
        replyListButton.hidden = true;
        replyAllSubButton.hidden = true;
        replyAllSubButtonSep.hidden = true;
      }
      else
      {
        // otherwise, hide the ReplyAll sub-buttons.
        replyAllSubButton.hidden = true;
        replyAllSubButtonSep.hidden = true;
      }
    }
    
    if (replyToSenderButton)
    {
      if (gFolderDisplay.selectedMessageIsFeed)
        replyToSenderButton.hidden = true;
      else
        replyToSenderButton.hidden = (replyButton && !replyButton.hidden);
    }
    
    UpdateReplyButtons();
  }
  
  pub.CHTUpdateJunkButton = function() {
    // The junk message should slave off the selected message, as the preview pane
    //  may not be visible
    let hdr = gFolderDisplay.selectedMessage;
    // But only the message display knows if we are dealing with a dummy.
    if (!hdr || gMessageDisplay.isDummy) // .eml file
      return;
    let junkScore = hdr.getStringProperty("junkscore");
    let hideJunk = (junkScore == Components.interfaces.nsIJunkMailPlugin.IS_SPAM_SCORE);
    if (!gFolderDisplay.getCommandStatus(nsMsgViewCommandType.junk))
       hideJunk = true;
    if (document.getElementById("hdrSJunkButton"))
      document.getElementById('hdrSJunkButton').disabled = hideJunk;
  }
  
  var CHTMessageListener = 
  {
    onStartHeaders: 
    function cML_onStartHeaders () {},
  
  	onEndHeaders: 
    function cML_onEndHeaders() {
      org.mozdev.customizeHeaderToolbar.pane.CHTUpdateReplyButton();
      org.mozdev.customizeHeaderToolbar.pane.CHTUpdateJunkButton();
    }
  };
  
  pub.CHTcheckFirstRun = function() {
    vCHT.version = -1;
    vCHT.firstrun = false;
    vCHT.gExtensionManager = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
    // check if this is part of CompactHeader
    if ((vCHT.gExtensionManager.getItemForID(CHT_EXTENSION_UUID) == null) || (pub.isAddonDisabled(CHT_EXTENSION_UUID))) {
    	return;
    }
    
    vCHT.current = vCHT.gExtensionManager.getItemForID(CHT_EXTENSION_UUID).version;
    try{
      vCHT.version = CHTprefBranch.getCharPref("version");
      vCHT.firstrun = CHTprefBranch.getBoolPref("firstrun");
    } catch(e) {
    } finally {
      //check for first run
      if (vCHT.firstrun){
        CHTprefBranch.setBoolPref("firstrun",false);
        CHTprefBranch.setCharPref("version",vCHT.current);
      }
      //check for upgrade
      if (vCHT.version!=vCHT.current && !vCHT.firstrun){
        CHTprefBranch.setCharPref("version",vCHT.current);
        // XXX
      }
    }
  }
  
  pub.CHTSetDefaultButtons = function() {
    var hdrToolbox = document.getElementById("header-view-toolbox");
    var hdrToolbar = document.getElementById("header-view-toolbar");
    var hdrBarDefaultSet = hdrToolbar.getAttribute("defaultset");
    var hdrBoxDefaultLabelalign = hdrToolbox.getAttribute("defaultlabelalign");
    var hdrBoxDefaultIconsize = hdrToolbox.getAttribute("defaulticonsize");
    var hdrBoxDefaultMode = hdrToolbox.getAttribute("defaultmode");
    var hdrBarDefaultIconsize = hdrToolbar.getAttribute("defaulticonsize");
    var hdrBarDefaultMode = hdrToolbar.getAttribute("defaultmode");  
    
    hdrToolbox.setAttribute("labelalign", hdrBoxDefaultLabelalign);
    hdrToolbox.setAttribute("iconsize", hdrBoxDefaultIconsize);
    hdrToolbox.setAttribute("mode", hdrBoxDefaultMode);
    hdrToolbar.setAttribute("iconsize", hdrBarDefaultIconsize);
    hdrToolbar.setAttribute("mode", hdrBarDefaultMode);
    
    hdrToolbar.currentSet = hdrBarDefaultSet;
    hdrToolbar.setAttribute("currentset", hdrBarDefaultSet);
    
    document.persist(hdrToolbox.id,"labelalign");
    document.persist(hdrToolbox.id,"iconsize");
    document.persist(hdrToolbox.id,"mode");
    document.persist(hdrToolbar.id,"iconsize");
    document.persist(hdrToolbar.id,"mode");
    document.persist(hdrToolbar.id,"currentset");
  }
  
  pub.CHTCleanupButtons = function() {
    var hdrToolbox = document.getElementById("header-view-toolbox");
    var hdrToolbar = document.getElementById("header-view-toolbar");
    var hdrBarDefaultSet = "hdrReplyButton,hdrReplyAllButton,hdrReplyListButton,hdrForwardButton,hdrArchiveButton,hdrJunkButton,hdrTrashButton";
    var hdrBoxDefaultLabelalign = hdrToolbox.getAttribute("defaultlabelalign");
    var hdrBoxDefaultIconsize = hdrToolbox.getAttribute("defaulticonsize");
    var hdrBoxDefaultMode = "full";
    var hdrBarDefaultIconsize = hdrToolbar.getAttribute("defaulticonsize");
    var hdrBarDefaultMode = "full";  
    
    hdrToolbox.setAttribute("labelalign", hdrBoxDefaultLabelalign);
    hdrToolbox.setAttribute("iconsize", hdrBoxDefaultIconsize);
    hdrToolbox.setAttribute("mode", hdrBoxDefaultMode);
    hdrToolbar.setAttribute("iconsize", hdrBarDefaultIconsize);
    hdrToolbar.setAttribute("mode", hdrBarDefaultMode);
    
    hdrToolbar.currentSet = hdrBarDefaultSet;
    hdrToolbar.setAttribute("currentset", hdrBarDefaultSet);
    
    document.persist(hdrToolbox.id,"labelalign");
    document.persist(hdrToolbox.id,"iconsize");
    document.persist(hdrToolbox.id,"mode");
    document.persist(hdrToolbar.id,"iconsize");
    document.persist(hdrToolbar.id,"mode");
    document.persist(hdrToolbar.id,"currentset");
  }
  
  pub.initializeOverlay = function() {
    var gExtensionManager = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
    // check if this is part of CompactHeader
    if ((gExtensionManager.getItemForID(CHT_EXTENSION_UUID) == null) || pub.isAddonDisabled(CHT_EXTENSION_UUID)) {
      return;
    }
  	UninstallObserver.register();
  }
  
  var UninstallObserver = {
    _uninstall : false,
    observe : function(subject, topic, data) {
      if (topic == "em-action-requested") {
        subject.QueryInterface(Components.interfaces.nsIUpdateItem);
    
        if (subject.id == CHT_EXTENSION_UUID) {
          if (data == "item-uninstalled") {
            this._uninstall = true;
          } else if (data == "item-cancel-action") {
            this._uninstall = false;
          }
        }
      } else if (topic == "quit-application-granted") {
        if (this._uninstall) {
          CHTprefBranch.deleteBranch("");
          pub.CHTCleanupButtons();
        }
        this.unregister();
      }
    },
    register : function() {
     var observerService =
       Components.classes["@mozilla.org/observer-service;1"].
         getService(Components.interfaces.nsIObserverService);
    
     observerService.addObserver(this, "em-action-requested", false);
     observerService.addObserver(this, "quit-application-granted", false);
    },
    unregister : function() {
      var observerService =
        Components.classes["@mozilla.org/observer-service;1"].
          getService(Components.interfaces.nsIObserverService);
    
      observerService.removeObserver(this,"em-action-requested");
      observerService.removeObserver(this,"quit-application-granted");
    }
  }
  
  pub.isAddonDisabled = function(uuid) {
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    var addon = rdfService.GetResource("urn:mozilla:item:" + uuid);
  
    var em = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
    var ds = em.datasource;
  
    var appRes = rdfService.GetResource("http://www.mozilla.org/2004/em-rdf#appDisabled");
    var appDisabled = ds.GetTarget(addon, appRes, true);
    if(appDisabled instanceof Components.interfaces.nsIRDFLiteral && appDisabled.Value == "true")
      return true;
  
    var userRes = rdfService.GetResource("http://www.mozilla.org/2004/em-rdf#userDisabled");
    var userDisabled = ds.GetTarget(addon, userRes, true);
    if(userDisabled instanceof Components.interfaces.nsIRDFLiteral && userDisabled.Value == "true")
      return true;
  
    return false;
  }
  return pub;
}();

addEventListener('load', org.mozdev.customizeHeaderToolbar.pane.initializeOverlay, false);
addEventListener('messagepane-loaded', org.mozdev.customizeHeaderToolbar.pane.CHTOnLoadMsgHeaderPane, true);
addEventListener('messagepane-unloaded', org.mozdev.customizeHeaderToolbar.pane.CHTOnUnloadMsgHeaderPane, true);
