unit ULex;
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : y.ouvrard@collatius.org}

// dbut du fichier collatinus.lex : 03 2C 29 O6 61 02 ...
{$MODE DELPHI}

interface
uses
  Classes;

type
  TDonneesLexicales = Class(TObject)
    modele,
    genre : integer;
    Radical2,
    Radical3,
    texte : String;
  public
    Constructor Create(m, g : integer ; T, R2,R3 : string);
    Constructor Lis(R : TReader);
    Procedure Ecris(W : TWriter);
    Function Morpho : string;
  end;

// pour en finir avec le tri des listes...
  TK = class(TObject)
  public
    Kanon : string;
    Constructor Create(K : string);
  end;

  TRadicaux = class(TStringList)
  public
    Constructor Create;
    Procedure Vide;
    Procedure Ajoute(R, K : String);
    Function CanonDe(R : String) : TList;
    end;

  TLexique = Class(TStringList)
  public
    Radices,
    Parfaits,
    Supins : TRadicaux;
    Modifie : boolean;
    {Constructor Create; overload;
    Constructor Create(F : string); overload;}
    Constructor Lis(R : TReader);
    Constructor Lis_xml;
    Procedure Ecris(W : TWriter);
    Function Donnees(N : integer ; strict : boolean) : TDonneesLexicales;
    Procedure ChargeAPartirDe(R : string ; NF : integer);
    Procedure PeupleRadicaux;
    Function CanonDe(R : String ; M : Integer) : TList ;
    Function Canons(F : string) : TStringList;
    Function CanonNumero(N : integer) : String;
    // Function Trouve(K : string; var p : integer ; M : integer) : Boolean;
    Function Trouve(K : string; var p : integer ; M : integer) : Boolean; overload;
    Function Trouve(
       K : string; var p : integer ; M : integer; R : string) : Boolean; overload;
    Procedure AjouteAuLexique(
      Remplacement : Boolean ;
      E : String ;
      D : TDonneesLexicales);
    Procedure DeleteLexico( p : integer );
    Function Stats : TStringList;
    function Entrees(g : string) : string;
  end;


// Procedure LisLexique; overload;
Procedure LisLexique(F : string);

Procedure LisLexique_xml;

// Procedure EcrisLexique; overload;
// Procedure EcrisLexique(L : TLexique;F : string); overload;

var
  Lexique : TLexique;

implementation

Uses SysUtils, Utiles, UDes, UListes, uirreg, Token, Crt;


{TDonneesLexicales}

Constructor TDonneesLexicales.Create(m, g : integer ; T, R2,R3 : string);
Begin
inherited Create;
modele := m;
genre := g;
Texte := T;
Radical2 := R2;
Radical3 := R3;
end;

Constructor TDonneesLexicales.Lis(R : TReader);
Begin
inherited Create;
// pour le premier item :
// 02 1E 02 FF 06 00 06 00 14 3C 00 00 70	
modele := R.ReadInteger;
genre := R.ReadInteger;                          
Radical2 := R.ReadString;
Radical3 := R.ReadString;
Texte := R.ReadString;                      
end;

Procedure TDonneesLexicales.Ecris(W : TWriter);
Begin
    W.WriteInteger(modele);
    W.WriteInteger(genre);
    W.WriteString(Radical2);
    W.WriteString(Radical3);
    W.WriteString(texte);
end;

Function TDonneesLexicales.Morpho : String;
Begin
Result := '';
if modele >= 0 then
  Result := Result + 'modle ' + ListeModeles[Modele];
if Genre >= 0 then
  Result := Result + ' ' + ListeGenres[Genre];
Result := Result + ' ' +
  Radical2 + ' ' + Radical3;
end;

{TK}

Constructor TK.Create(K : string);
Begin
Kanon := K;
end;

{Radicaux}

Constructor TRadicaux.Create;
Begin
inherited Create;
Sorted := True;
Duplicates := dupAccept;
end;

Procedure TRadicaux.Vide;
Begin
Clear;
end;

Procedure TRadicaux.Ajoute(R, K  : String);
Begin
if R = '' then exit;
addObject(R, TK.Create(K));
end;

Function TRadicaux.CanonDe(R : String) : TList;
   // peut-tre  perfectionner : le mme
   //   radical pour deux canons diffrents :
   //   lepus, oris - lepos, oris !
   // pour le moment, la dcl est  placer dans les irrguliers.
var p : integer;
Begin
result := TList.Create;
if not find(R, p) then exit;
while (R = strings[p]) and (p < count - 1) do
  begin
    Result.Add(TK(Objects[p]));
    inc (p);
  end;
// dbogage :
end;

{ TLexique }

{Constructor TLexique.Create; overload;
Begin
  inherited Create;
  Sorted := True;
  Duplicates := dupAccept ;
  Radices := TRadicaux.Create;
  Parfaits := TRadicaux.Create;
  Supins := TRadicaux.Create;
end;}

Constructor TLexique.Lis(R : TReader);
var C : integer;
    S : String;
    D : TDonneesLexicales;
Begin
inherited Create;
Sorted := True;
Duplicates := dupAccept ;
Radices := TRadicaux.Create;
Parfaits := TRadicaux.Create;
Supins := TRadicaux.Create;
C := R.ReadInteger;
While C > 0 do
  begin
  S := R.ReadString;
  D := TDonneesLexicales.Lis(R);
  AddObject(S, D);
  dec(C);
  end;
PeupleRadicaux;
Modifie := false;
end;

Constructor TLexique.Lis_xml;
var
   liste : TStringList;
   chemin : string;
   m, g : integer;
   gr, T, R2, R3 : string;
   i : integer;
   { points : integer;
const
    roue = '|/-\';}

   function debaliser(b, l : string) : string;
   var
      len : integer;
      p : integer;
   begin
      len := length (b);
      p := pos('<' + b + '>', l) + len + 2;
      result := copy (l, p, length(l));
      p := pos ('</' + b, result) - 1;
      result := copy (result, 1, p)
   end;

begin
inherited Create;
Sorted := True;
Duplicates := dupAccept ;
Radices := TRadicaux.Create;
Parfaits := TRadicaux.Create;
Supins := TRadicaux.Create;

liste := TStringList.Create;
// 3 juillet 2003 : installation de type linux
if fileexists (share + 'canons.xml')
   then chemin := share
else chemin := extractFilePath(Paramstr(0));
writeln('lecture du lexique en ' + chemin);
liste.LoadFromFile (chemin + 'canons.xml');
// passer l''en-tte
i := 0;
while pos('<collatinus>', liste[i]) < 1
   do inc(i);
inc (i);
g := -1; gr := ''; T := ''; R2 := ''; R3 := '';
// points := 0;
while pos('</collatinus>', liste[i]) < 1 do
   begin
      if pos ('<graphie>', liste[i]) > 0
        then gr := debaliser('graphie', liste[i])
      else if pos ('<genre>', liste[i]) > 0
         then g := StrToInt (debaliser ('genre', liste[i]))
      else if pos ('<modele>', liste[i]) > 0
         then m := StrToInt (debaliser ('modele', liste[i]))
      else if pos ('<texte>', liste[i]) > 0
         then T := debaliser ('texte', liste[i])
      else if pos ('<R2>', liste[i]) > 0
         then R2 := debaliser ('R2', liste[i])
      else if pos ('<R3>', liste[i]) > 0
         then R3 := debaliser ('R3', liste[i])
      else if pos ('</canon>', liste[i]) > 0 then
         begin
	    {// portion  dcommenter pour avoir un signal de chargement.
            inc (points);
            if points mod 100 = 0 then
               begin
                  GotoXY(2,WhereY);
                  ClrEol;
                  write(roue[1+((points div 100) mod 4)]);
               end; }
            AddObject (gr, TDonneesLexicales.Create(m, g, T, R2,R3));
            g := -1; gr := ''; T := ''; R2 := ''; R3 := '';
         end;
      inc(i);
   end;
liste.free;
PeupleRadicaux;
Modifie := false;
end;

Procedure TLexique.Ecris(W : TWriter);
var i : integer;
Begin
W.WriteInteger(count);
for i := 0 to count-1 do
  Begin
  W.WriteString(strings[i]);
  Donnees(i, true).ecris(W);
  end;
end;

Procedure TLexique.PeupleRadicaux;
var i, iRad : integer;
Begin
Radices.vide;
Parfaits.vide;
Supins.Vide;
For i := 0 to count-1 do With Donnees(i, true) do
  Case Modele of
    5..8, 14, 15 : // noms et adj. 3me
      For iRad := 1 to NumToken(Radical2, virgule) do
        Radices.Ajoute(
          GetToken(Donnees(i, true).Radical2, virgule, iRad), Strings[i]);
    17..28 :
      begin
      if Radical2 <> '' then
        For iRad := 1 to NumToken (Radical2, virgule) do
          Parfaits.Ajoute(
            GetToken(Radical2, virgule, iRad), Strings[i]);
      if Radical3 <> '' then
        For iRad := 1 to NumToken (Radical3, virgule) do
          Supins.Ajoute(
            GetToken(Radical3, virgule, iRad), Strings[i]);
      end;
    end;
end;

Function TLexique.CanonDe(R : String ; M : Integer) : TList ;
  var K : String;
      L : TList;
      i : integer;
Begin
L := nil;
Case M of
  0 : K := R+'a';
  1, 9, 11 : K := R+'us';
  2, 3, 12, 13, 16 : K := R+'er';
  4 : K := R + 'um';
  5..8, 14, 15 : // 3me dcl
    begin
     L := Radices.CanonDe(R);
     K := '';
    end;
  10 : K := R + 'es';
  // 16 : K := ChangeDes(K, 'r', 'er'); // acer
  17, 19 : K := R + 'o';
  18, 23 : K := R+'eo';
  20, 21 : K := R + 'io';
  22 : K := R + 'sum';
  24, 26 : K := R + 'or';
  25 : K := R + 'eor';
  27, 28 : K := R + 'ior';
  end;

Result := TList.Create;
if K > ''
  then Result.Add(TK.Create(K))
  else if L.Count > 0
    then for i := 0 to L.count - 1
      do Result.Add(L[i]);
end;

Procedure TLexique.ChargeAPartirDe(R : string ; NF : integer);
var iLex, Genre : integer;
    L : TStringList;
Begin
L := TStringList.Create;
L.LoadFromFile(R+ListeModeles[NF]+'.txt');
For ilex := 0 to L.Count-1 do
       begin
       if pos(' m.', L[Ilex]) > 0 then
         Genre := 0
         else if
          pos(' f.', L[Ilex]) > 0 then
          Genre := 1
         else if
          pos(' n.', L[Ilex]) > 0 then
          Genre := 2
          else genre := -1;
       Lexique.Addobject(
         AGauche(',', L[ilex]),
         TDonneesLexicales.Create(
           NF, genre, CoupeAGauche(',', L[Ilex]), '',''));
       end;
end;

Function TLexique.Donnees(N : integer ; strict : boolean) : TDonneesLexicales;
Begin
result := TDonneesLexicales(Objects[N]) ;
if strict then exit;
if (pos('cf. ', result.Texte) > 0) and
   (find(copy(result.texte, 6, length(result.texte)), N))
   then result := Donnees(N, true);
end;

Function TLexique.CanonNumero(N : integer) : String;
  var P : integer;
      K : string;
  Begin
  Result := Strings[N];
  K := Donnees(N, true).Texte;
  P := pos('cf. ', K);  // renvoyer vers une autre entre
  if  (P > 0) and (P < 3) and (Find(copy(K, 6, length(K)), P))
   then Result := Strings[P];
  end;

Function TLexique.Canons(F : string) : TStringList;
var i : integer;
Begin
Result := TStringList.Create;
Result.Add(F);
if find(F, i) then
  While strings[i] = F do
    begin
    Result.Add(' - '+strings[i] + ', ' + donnees(i, true).texte);
    inc(i);
    end;
end;


Function TLexique.Trouve(K : string; var p : integer ; M : integer) : Boolean;
{semblable  Find(K : string ; var p : integer):boolean ,
  mais exige en plus le modle n M, et cherche donc
  les homonymes ; s'il n'en trouve pas, revoie false}
Begin
Result := False;
if (Find(K, p)) then
  While (strings[p] = K)  do
    Begin
      result := Donnees(p, false).Modele = M;
      if not result then inc(p) else Break;
    end;
end;

Function TLexique.Trouve(
   K : string; var p : integer ; M : integer; R : string) : Boolean;
{semblable  Trouve(K : string; var p : integer ; M : integer),
  mais exige en plus le radical 2 R}
Begin
Result := False;
if (Find(K, p)) then
  While (strings[p] = K)  do
    Begin
      result := (Donnees(p, false).Modele = M)
            and (Donnees(p, false).Radical2 = R) ;
      if not result then inc(p) else Break;
    end;
end;

Function TLexique.stats : TStringList;
  begin
    Result := TStringList.Create;
    Result.Add( 'Lexique de Collatinus - Statistiques' );
    Result.Add( '=========================' );
    Result.Add( ' ' );
    Result.Add( IntToStr(Count) + ' entres');
    Result.Add( IntToStr(Desinences.Count) + ' dsinences');
    Result.Add( IntToStr(Irregs.Count) + ' formes irrgulires');
  end;


Procedure TLexique.AjouteAuLexique(Remplacement : Boolean ;
  E : String ; D : TDonneesLexicales);
var p : integer;
Begin
if Remplacement and
  Trouve(E, p, D.Modele)
  Then DeleteLexico(p);
// au lexique :
AddObject(E, D);
// reconstruire les radicaux
PeupleRadicaux;
Modifie := true;
end;

Procedure TLexique.DeleteLexico( p : integer );
Begin
Delete(p);
// reconstruire les radicaux
PeupleRadicaux;
Modifie := true;
end;

Function TLexique.Entrees (g : string) : string;
var p : integer;
begin
   if find(g, p)
      then with Donnees(p, true)
         do result := strings[p] + ' modle ' + intToStr(modele) 
	    + ', R2 ' + Radical2 + 
            + ', R3 ' + Radical3 + #10' texte : ' + texte
   else result := 'lemme inconnu';
end;

{ procdures globales de lecture et d'criture}

Procedure LisLexique(F : string); overload;
Var S : TFileStream;
    R : TReader;
Begin

S := TFileStream.Create(
  ExtractFilePath(Paramstr(0)) + F, fmOpenRead);
R := TReader.Create(S, 1024); 
Lexique := TLexique.Lis(R);
Desinences := TListeDes.Lis(R);
Irregs := TListeIrreg.Lis(R); 
R.Free;
S.Free;
end;

{
Procedure LisLexique; overload;
begin
  LisLexique(lexique, 'collatinus.lex');
end;
}

Procedure LisLexique_xml;
begin
   Lexique := TLexique.Lis_xml;
   Desinences := TListeDes.Lis_xml;
   Irregs := TListeIrreg.Lis_xml;
end;

Procedure EcrisLexique (L : TLexique; F : String); 
Var S : TFileStream;
    W : TWriter;
Begin
S := TFileStream.Create(
  ExtractFilePath(Paramstr(0)) + F, fmOpenWrite);
W := TWriter.Create(S, 1024);
L.Ecris(W);
Desinences.Ecris(W);
Irregs.Ecris(W);
W.Free;
S.Free;
L.Modifie := false;
end;


{Procedure EcrisLexique; overload;
begin
   EcrisLexique(lexique, 'collatinus.lex');
end;}

{constructor TLexique.Create(F: string); overload;
Var S : TFileStream;
    R : TReader;
Begin
S := TFileStream.Create(
  ExtractFilePath(Paramstr(0)) + F, fmOpenRead);
R := TReader.Create(S, 1024);
self := TLexique.Lis(R);
R.Free;
S.Free;
Modifie := false;
end;}

end.
