/****************************************************************************
 *    lib/c/QQuery.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "QQuery.h"

using namespace C;

QQuery::QQuery(int line, string type, Formula* I, string* time, Types* types) : Statement(line, types), Query(line, types) {
	type_ = type;
	I_ = I;
	time_ = *time;
}

QQuery::~QQuery ( ) { }

void QQuery::print(Printer* p) {
	if(p->rev) {
		if(time_ == "0") time_ = "-t";
		else if(time_ == "t") time_ = "0";
		else {
			time_ = "-" + time_;
			cerr << "Warning: Setting time of query in line " << line_ << " to " << time_ << ".\n";
			cerr << "         This will most likely cause problems with the reverse incremental encoding.\n";
		}
	}
	
	if(time_ == "0") p->setSection('b');
	else p->setSection('v');

	FluentAction* i;
	string neg = p->neg;

	// :- not f1, ..., not f_n
	for(vector<Formula*>::iterator n = I_->begin(); n != I_->end(); ++n) {
		if((*n)->getType() == 'n') {
			i = (FluentAction*) (*n)->getFirstFormula();
			neg = p->neg;
		}
		else {
			i = (FluentAction*) *n;
			neg = "";
		}
		
		p->add(":- not ");
		if(p->no_direct_enc) {
			p->add(type_+"(");
			if(neg == "") {
				p->add(i->print(p, time_));
				p->add(", " + time_ + ")");
			}
			else {
				p->add("neg(" + i->print(p, time_));
				p->add("), "+time_+")");
			}
		}
		else {
			p->add(neg + i->print(p, time_));
		}

		set<Variable*>* vars = i->getVariables();
		if(!vars->empty()) {
			p->add(", ");
			types_.print(p, vars, line_);
		}
		p->add(".\n");

		delete vars;
	}
}
