# - Look for GNU flex, the lexer generator.
# Defines the following:
#  FLEX_EXECUTABLE - path to the flex executable
#  FLEX_FILE - parse a file with flex

IF(NOT FLEX_EXECUTABLE)
  MESSAGE(STATUS "Looking for flex")
  FIND_PROGRAM(FLEX_EXECUTABLE "flex")
  IF(FLEX_EXECUTABLE)
    MESSAGE(STATUS "Looking for flex -- ${FLEX_EXECUTABLE}")
  ELSE(FLEX_EXECUTABLE)
    MESSAGE(FATAL_ERROR "flex not found")
  ENDIF(FLEX_EXECUTABLE)
ENDIF(NOT FLEX_EXECUTABLE)

IF(FLEX_EXECUTABLE)
  MACRO(FLEX_FILE FILENAME)
    GET_FILENAME_COMPONENT(PATH "${FILENAME}" PATH)
#    IF(NOT EXISTS "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")
#      FILE(MAKE_DIRECTORY "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")
#    ENDIF(NOT EXISTS "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")
    GET_FILENAME_COMPONENT(PREFIX "${FILENAME}" NAME_WE)
    SET(OUTFILE "${CMAKE_CURRENT_SOURCE_DIR}/${PATH}${PREFIX}.cpp")
    ADD_CUSTOM_COMMAND(
      OUTPUT "${OUTFILE}"
      COMMAND "${FLEX_EXECUTABLE}"
      ARGS "--outfile=${OUTFILE}"
      "${CMAKE_CURRENT_SOURCE_DIR}/${FILENAME}"
      DEPENDS "${CMAKE_CURRENT_SOURCE_DIR}/${FILENAME}")
    SET_SOURCE_FILES_PROPERTIES("${OUTFILE}" PROPERTIES GENERATED TRUE)
  ENDMACRO(FLEX_FILE)
ENDIF(FLEX_EXECUTABLE)
