/* This file is part of Clementine.
   Copyright 2010, David Sansome <me@davidsansome.com>

   Clementine is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Clementine is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Clementine.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "script.h"
#include "scriptinterface.h"

Script::Script(LanguageEngine* language, const ScriptInfo& info)
  : interface_(new ScriptInterface(this)),
    language_(language),
    info_(info)
{
}

Script::~Script() {
}

void Script::AddNativeObject(QObject* object) {
  if(!native_objects_.contains(object)) {
    native_objects_ << object;
  }
}

void Script::RemoveNativeObject(QObject* object) {
  native_objects_.removeAll(object);
}
