/* cp_main.c = main file for the program called "CirclePack", Version 3.1
Copyright Kenneth Stephenson, 1992, 1993, 1994, 1995 all rights reserved. 
May be distributed with permission.

Related files are:
	headers: 
	        cp_types.h = principal type definitions, general
		cp_head.h = CirclePack global variables, XView, etc. 
		complex_math.h = complex arith and transformations header
		eucl_math.h = eucl geometry header
		hyp_math.h = hyp geometry header
		sph_math.h = sph geometry header
		cp_remote.h = for writing remote routines
	program files more-or-less specific to CirclePack:
		cp_main.c = main
		cp_cmd.c = to parse/exec commands
		cp_action.c = actions called by notifier
		cp_call.c = parsing calls to library routines
		cp_io.c = input/output routines
		cp_format.c = formating of window environ
		cp_screen.c = screen handling
		cp_special.c = tailored routines for "special" button
		cp_remote.c = setup, talk to remote routines
		cp_xview.c = segregating Xview calls
	Libraries: main repository for routines
	        libCP_libs.a
	Math routines:
		complex_math.c
		eucl_math.c
		hyp_math.c
		sph_math.c
		mobius_math.c
	Misc files:
		cp_help.info = text help file, including "Help" button
		.packrc = optional configuration file for user choices
		.packwp = optional saved workplace layout
*/

#include "cp_head.h"

int main(int argc,char *argv[])
{
	int i,j,k,sflag=0;
	char init_pack_name[NAME_MAX];
	char inmsg[BUFSIZE];
	extern int base_resize_proc();
	uid_t myuid;
	struct passwd *mypassdata;	
	Rect rect;

/* copyright notice */

	strncpy(CPVersion,"5.1",4);
	printf("\n\n                   CirclePack, Version %s, \n\n",
	       CPVersion);
	printf("                   Copyright 1992 -- 2001\n\n");
	printf("Kenneth Stephenson, University of Tennessee, ");
	printf("Knoxville, kens@math.utk.edu\n\n");

	printf("Initialization in progress\n");

/* create principal pack and screen pointers */

	if ((packdata=(struct p_data *)
		calloc((size_t)(NUM_PACKS+1),sizeof(struct p_data)))==NULL
	    || (screendata=(struct s_data *)
		calloc((size_t)(NUM_PACKS+1),sizeof(struct s_data)))==NULL)
	 {
		printf("Memory allocation problems for packings.\n");
		exit(1);
	 }

/* some global variable initializations */

	set_cp_globals(); /* set library globals */

	cmd_mode=0; /* default: GUI interface */
	current_p=0;
	eucl_factor=0.5;
	inc_factor=1.0717735; /* 10th root of 2 (equates to 10%) */
	draw_speed=0;
	totalpasses=500;
	canv_size=CANV_SIZE;
	custom_fp=NULL;
	cmd_search_depth=0;
	next_script_cmd=NULL;
	Mob=ident_mob();
	b_flip=r_flip=NULL;
        init_shmem = 0;
	rgb_file[0]='\0';
	list_ready=0;
	init_pack_name[0]=script_name[0]='\0';
	ScrX=ScrY=600;
	script_fp=log_fp=NULL;

	myuid=getuid();
	mypassdata=getpwuid(myuid); /* get .pw_dir=home directory */
	strncpy(user_name,mypassdata->pw_name,63); /* user name? */
	home_dir=mypassdata->pw_dir;
	getcwd(buf,BUFSIZE);
	working_dir=(char *)calloc((size_t)(strlen(buf)+3),sizeof(char));
	strncpy(working_dir,buf,strlen(buf)+1);

/* look for command line arguments. */

	for (i=1;i<argc;i++)
	 {
	   if (!strcmp(argv[i],"-colorfile")) /* file of rgb colors */
	     {
	       strncpy(rgb_file,argv[i+1],NAME_MAX);
	       i++;
	     }
	   if (!strcmp(argv[i],"-p")) /* read and display packing */
	     {
	       strncpy(init_pack_name,argv[i+1],NAME_MAX);
	       i++;
	     }
	   if (!strcmp(argv[i],"-cmd")) /* command line mode (versus
					   GUI interface mode) */
	     {
	       cmd_mode=1;
	       log_fp=fopen("/tmp/CP_log.txt","w");
	       i++;
	     }
	       
	   else  /* any other argument is taken as 'script' filename */
	     {
	       sflag=1;
	       strncpy(script_name,argv[i],NAME_MAX);
	     }
	 }

/* various default initializations */

	strcpy(packing_dir_name,"packings/"); /* directory name for
		reading and writing files; default = current */
	strcpy(print_cmd,"lpr -h "); /* set print command */
	strcpy(ps_file_name,"sel_post.ps"); /* postscript filename 
		for custom printing */
	strcpy(print_file_name,"pack_post.ps"); /* postscript filename 
		for screen printing */

/* find help/packrc; read `.packrc' file for user-specified quantities */

	find_help_packrc(argv[0]); 

/* initialize some pack and screen data, window locations, etc. */

	for (i=0;i<NUM_PACKS;i++)
	 {
		packdata[i].sizelimit=5000;
		packdata[i].screen=screendata+i;
		alloc_edge_pair(&packdata[i]);
		if (i==0 && strlen(init_pack_name))
		  sprintf(packlabels[0],"Pack 0: %s ",init_pack_name);
		else sprintf(packlabels[i],
		 "Pack %d: empty             ",i);
		live_face[i]=live_node[i]=1;
				
		screendata[i].box=std_real_box; 
		screendata[i].pix_box.lx=screendata[i].pix_box.ly=0;
		screendata[i].pix_box.rx=screendata[i].pix_box.ry=canv_size;

		screendata[i].factor=1.0;
			/* set default view matrices */
		for (k=0;k<3;k++) 		 {
			for (j=0;j<3;j++)
			   screendata[i].disp_trans[k][j]=
				screendata[i].disp_inv_trans[k][j]=0.0;
			screendata[i].disp_trans[k][k]=
				screendata[i].disp_inv_trans[k][k]=1.0;
		 }
		sprintf(buf,"set_sphere_view -p%d -d",i);
		handle_cmd(buf,&current_p);
		screendata[i].coord_flag=0;
		screendata[i].cflag_opt=1;
		screendata[i].fflag_opt=0;
		screendata[i].ms_flag=0;
	 }
	for (i=0;i<NUM_PACKS;i++) 
		if (!alloc_pack_space(&packdata[i],5000,0))
		 { printf("Memory allocation problems.\n");exit(1);}

/* If GUI mode, build frames, initialize XLib stuff, windows, etc. */

	if (!cmd_mode)
	  {
	    frame_builder(); /* builds XView frames */
	    DefaultScreen(display);

	    if (!ScrX)
	      ScrX=0;ScrY=DisplayHeight(display,DefaultScreen(display))-600;

	    set_pack_dir_name(packing_dir_name); 
	    set_print_cmd(print_cmd); 
	    set_ps_file(ps_file_name); 
	    set_print_file(print_file_name);

	    if (stat_file(CPHelp)) xv_set(help_sw,TEXTSW_FILE,CPHelp,0);
	    set_packing_path();

	    for (i=0;i<NUM_PROC;i++) 
	      remote[i].notify_client=(Notify_client)(100+i);
	    for (i=0;i<NUM_PACKS;i++)
	      xv_set(canvas_frame[i],
		     XV_HEIGHT,canv_size,XV_WIDTH,canv_size,
		     WIN_X,50+i*25+(canv_size+10)*(int)(i%2),
		     WIN_Y,180+12*(int)(i>1),
		     0);
	    set_pack_labels();

	    /* script file specified? */	
	    if (sflag) 
	      {
		set_script_name(script_name);
		notify_dispatch(); 
		strcpy(msgbuf,"*** Script ready in `Script Window' ***"
		       "\nPress button 'Execute next cmd' to "
		       "execute prepared commands.\0");
		msg();
		Flush();
	      }
	    else 
	      {
	        notify_dispatch();
		strcpy(msgbuf,"*** New user? Type 'script demo.cmd' "
		       "on `Command:' line to run a prepared script.\0");
		msg();
	 	Flush();
	      }

	    rect.r_left=ScrX;rect.r_top=ScrY;    /* main */
	    rect.r_width=630;rect.r_height=150;
	    frame_set_rect(base_frame,&rect);
	    rect.r_top += 180;rect.r_height=35;  /* cmd */
	    frame_set_rect(cmd_frame,&rect);
	    rect.r_top +=60;rect.r_height=130;    /* msg */
	    frame_set_rect(msg_frame,&rect);
	    rect.r_left=ScrX+630;rect.r_top=ScrY; /* scratch */
	    rect.r_width=300;rect.r_height=200;
	    frame_set_rect(text_frame,&rect);
	    cmd_up(sflag);

	    read_workspace(sflag);

	    if (strlen(init_pack_name))
	      {
		sprintf(buf,"read %s",init_pack_name);
		handle_cmd(buf,&current_p);

		/* close windows that might be opened otherwise */
		xv_set(msg_frame,WIN_SHOW,FALSE,0);
		xv_set(script_frame,WIN_SHOW,FALSE,0);
		xv_set(history_frame,WIN_SHOW,FALSE,0);
		xv_set(text_frame,WIN_SHOW,FALSE,0);
		xv_set(help_frame,WIN_SHOW,FALSE,0);
		for(i=1;i<NUM_PACKS;i++)
		  xv_set(canvas_frame[i],WIN_SHOW,FALSE,0);
		sprintf(buf,"close m");
		handle_cmd(buf,&current_p);
		sprintf(buf,"close d");
		handle_cmd(buf,&current_p);
		sprintf(buf,"close w");
		handle_cmd(buf,&current_p);
		sprintf(buf,"disp -w -c");
		handle_cmd(buf,&current_p);
	      }

	    /* GUI main notifier loop; get mouse/keyboard input */

	    window_main_loop(base_frame); 

	  } /* end of GUI mode initiation */

/* Cmd mode: input from command line only */

	else 
	  {
	    set_packing_path();
	    if (sflag)
	      {
		sprintf(buf,"script %s",script_name);
		handle_cmd(buf,&current_p);
	      }
	    if (strlen(init_pack_name))
	      {
		sprintf(buf,"read %s",init_pack_name);
		handle_cmd(buf,&current_p);	
	      }

	    /* enter notifier loop; continually read commands from stdin. */

	    printf("\ncmd: ");
	    while (fgets(inmsg,BUFSIZE,stdin))
	      {
		if (log_fp) fprintf(log_fp,"%s\n",inmsg);
		i=sort_cmd(inmsg,&current_p);
		printf("\n  <%d Cmds>\ncmd: ",i);
	      } 

	  }
	puts("CirclePack exited normally.");
	exit(0);
} /* main */


