#include "cp_types.h"
#include "cp_proto.h"

/* Verify that red chain is contiguous closed chain. Return 0 if error.
Put info in "/tmp/diagnostic_log". */

int check_red_chain(struct p_data *p)
{
  int count=0,wflag=0;
  struct RedList *trace;
  FILE *diagfp;

  if (!(diagfp=fopen("/tmp/diagnostic_log","a"))) return 0;
  fprintf(diagfp,"\n\nCheck redfaces:   ");
  if (!p->redfaces && (p->genus>0 || p->euler!=-2))
    {
      fprintf(diagfp,"\n   There's no redchain, yet complex is not "
	      "a topological sphere: genus = %d, euler = %d.\n",
	      p->genus,p->euler);
      fclose(diagfp);
      return 0;
    }
  trace=p->redfaces;
  while (count<2*p->facecount 
	 && (trace!=p->redfaces || !(wflag++)) )
    {
      if (nghb_tri(p,trace->face,trace->next->face)<0)
	goto BAD;
      if (trace->prev->next!=trace 
	  || trace->next->prev!=trace) goto BAD;
      trace=trace->next;
      count++;
    }
  if (count==2*p->facecount)
    {
      fprintf(diagfp,"\n   Seems to run away; total face "
	      "count is %d, \n     but list doesn't close up "
	      "in %d steps.",
	      p->facecount,count);
      fclose(diagfp);
      return 0;
    }
  fprintf(diagfp,"Seems OK. Count = %d",count);
  fclose(diagfp);
  return count;

 BAD:
  fprintf(diagfp,"\n   Problem occurred: face %d (address %ld), "
	  "next face %d, count %d.",
	  trace->face,(long)trace,trace->next->face,count);
  fclose(diagfp);
  return 0;
} /* check_red_chain */




