use strict;
use warnings;
use Module::Build::CipUX;

my $builder = Module::Build::CipUX->new(
    module_name       => 'CipUX::RBAC::Simple',
    license           => 'gpl',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version_from => 'lib/CipUX/RBAC/Simple.pm',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    #    verbose            => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'File::Spec'          => 0,
        'Test::Perl::Critic'  => 0,
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {
        'Test::LeakTrace'      => 0,
        'Module::Build::CipUX' => '0.3.0',
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
        'Test::Refcount'       => 0,
    },

    requires => {
        'Carp'            => 0,
        'CipUX'           => '3.4.0.0',
        'CipUX::Task'     => '3.4.0.0',
        'Class::Std'      => '0.0.9',
        'Data::Dumper'    => 0,
        'English'         => 0,
        'Graph'           => 0,
        'Graph::Directed' => 0,
        'Log::Log4perl'   => 0,
        'Readonly'        => 0,
        'version'         => 0,
    },

    add_to_cleanup => ['CipUX-RBAC-Simple-*'],
);

# BUILD target
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->create_build_script();
