#!/bin/bash 
# install plugin in the standard childsplay path  

PREFIX=/usr/local
DESTDIR=$PREFIX/share/childsplay

###########################################################
#    DO NOT EDIT BEHIND THIS POINT
# Unless your know what to edit
##########################################################

# Dependency, which version of childsplay at least
DEPEN=0.71
 
set -e
CWD=`pwd`

USERID=`id | sed -e 's/).*//; s/^.*(//;'`
if [ "$USERID" != "root" ]; then
    echo " You must be root to install the plugins"
    echo " exit"
    exit 1
fi

echo -e "\n>>>>>>>>>>> Install childsplay plugins >>>>>>>>>>>>>>>>>>>>"
echo -e "\n This release depends on childsplay version $DEPEN"
echo -n " Cheking version = "
VERSION=$(childsplay --version)
echo $VERSION

if [ `expr $VERSION \< $DEPEN` -eq 1 ];then
    echo " Childsplay version incorrect, please upgrade to at least"
    echo " version $DEPEN"
    echo "exit"
    exit 1
fi
   
echo -e "\n The path to install the soundfiles in is "
echo " $DESTDIR."
echo " If you have installed childsplay in a other place, you can"
echo " give the full path to childsplay, otherwise just hit enter"
echo " Hit enter to install in $DESTDIR, or give the full path"
read path
if [ $path ];then
    if [ -e $path/install.py ];then
        DESTDIR=path
    else
        echo "*********** WARNING *************"
        echo " $path does not exists or is not the childsplay directory"
        echo " exit"
        exit 1
    fi
fi
echo " Installing in $DESTDIR/Data/AlphabetSounds"

echo " Copy sound files"
cp -rf $CWD/AlphabetSounds $DESTDIR/Data/

echo -e "\n Everything installed, enjoy\n"
