/* { dg-do run } */
/* { dg-options "-O3" } */

#include <stdio.h>

typedef __attribute__((vector_size(16))) signed int vsi4;
typedef __attribute__((vector_size(16))) unsigned int vui4;
typedef __attribute__((vector_size(16))) float vf4;

union U {
  vsi4 _vsi4;
  vui4 _vui4;
  vf4 _vf4;
  signed int vsi4_a[4];
  unsigned int vui4_a[4];
  float vf4_a[4];
};

int fail;
#define FAIL do { printf ("line %d\n", __LINE__); fail++; } while (0)

#define TEST_RELATIONAL(TYPE,NAME,OP) \
int \
do_##TYPE##_##NAME(TYPE a, TYPE b) \
{ \
  union U ua, ub; \
  int actual, expected, i; \
  ua._##TYPE = a; \
  ub._##TYPE = b; \
  actual = (a OP b); \
  expected = 1; \
  for (i = 0; i < 4; i++) \
    expected &= (ua.TYPE##_a[i] OP ub.TYPE##_a[i]); \
  if (actual != expected) \
  { \
    printf ("actual %d expected %d\n", actual, expected); \
    for (i = 0; i < 4; i++) \
      printf ("%d " #OP " %d = %d\n", ua.TYPE##_a[i], ub.TYPE##_a[i], (ua.TYPE##_a[i] OP ub.TYPE##_a[i])); \
  } \
  return actual == expected; \
}  \
void \
test_##TYPE##_##NAME() \
{ \
  TYPE a = {0, 0, 0, 0}; \
  TYPE b = {0, 0, 1, 1}; \
  TYPE c = {1, 1, 1, 1}; \
  if (!do_##TYPE##_##NAME(a,a)) FAIL; \
  if (!do_##TYPE##_##NAME(a,b)) FAIL; \
  if (!do_##TYPE##_##NAME(a,c)) FAIL; \
  if (!do_##TYPE##_##NAME(b,b)) FAIL; \
  if (!do_##TYPE##_##NAME(b,c)) FAIL; \
  if (!do_##TYPE##_##NAME(c,c)) FAIL; \
}


#define TEST_NOT_RELATIONAL(TYPE,NAME,OP) \
int \
do_##TYPE##_not_##NAME(TYPE a, TYPE b) \
{ \
  union U ua, ub; \
  int actual, expected, i; \
  ua._##TYPE = a; \
  ub._##TYPE = b; \
  actual = !(a OP b); \
  expected = 1; \
  for (i = 0; i < 4; i++) \
    expected &= (ua.TYPE##_a[i] OP ub.TYPE##_a[i]); \
  expected = !expected; \
  if (actual != expected) \
  { \
    printf ("actual %d expected %d\n", actual, expected); \
    for (i = 0; i < 4; i++) \
      printf ("%d " #OP " %d = %d\n", ua.TYPE##_a[i], ub.TYPE##_a[i], (ua.TYPE##_a[i] OP ub.TYPE##_a[i])); \
  } \
  return actual == expected; \
}  \
void \
test_##TYPE##_not_##NAME() \
{ \
  TYPE a = {0, 0, 0, 0}; \
  TYPE b = {0, 0, 1, 1}; \
  TYPE c = {1, 1, 1, 1}; \
  if (!do_##TYPE##_not_##NAME(a,a)) FAIL; \
  if (!do_##TYPE##_not_##NAME(a,b)) FAIL; \
  if (!do_##TYPE##_not_##NAME(a,c)) FAIL; \
  if (!do_##TYPE##_not_##NAME(b,b)) FAIL; \
  if (!do_##TYPE##_not_##NAME(b,c)) FAIL; \
  if (!do_##TYPE##_not_##NAME(c,c)) FAIL; \
}

#define TEST_AND_NOT_RELATIONAL(TYPE,NAME,OP) \
int \
do_##TYPE##_and_not_##NAME(TYPE a, TYPE b) \
{ \
  union U ua, ub; \
  int actual, expected, i; \
  ua._##TYPE = a; \
  ub._##TYPE = b; \
  actual = (a OP b) && !(a OP b); \
  expected = 1; \
  for (i = 0; i < 4; i++) \
    expected &= (ua.TYPE##_a[i] OP ub.TYPE##_a[i]); \
  expected = expected && !expected; \
  if (actual != expected) \
  { \
    printf ("actual %d expected %d\n", actual, expected); \
    for (i = 0; i < 4; i++) \
      printf ("%d " #OP " %d = %d\n", ua.TYPE##_a[i], ub.TYPE##_a[i], (ua.TYPE##_a[i] OP ub.TYPE##_a[i])); \
  } \
  return actual == expected; \
}  \
void \
test_##TYPE##_and_not_##NAME() \
{ \
  TYPE a = {0, 0, 0, 0}; \
  TYPE b = {0, 0, 1, 1}; \
  TYPE c = {1, 1, 1, 1}; \
  if (!do_##TYPE##_and_not_##NAME(a,a)) FAIL; \
  if (!do_##TYPE##_and_not_##NAME(a,b)) FAIL; \
  if (!do_##TYPE##_and_not_##NAME(a,c)) FAIL; \
  if (!do_##TYPE##_and_not_##NAME(b,b)) FAIL; \
  if (!do_##TYPE##_and_not_##NAME(b,c)) FAIL; \
  if (!do_##TYPE##_and_not_##NAME(c,c)) FAIL; \
}

#define TEST_OR_NOT_RELATIONAL(TYPE,NAME,OP) \
int \
do_##TYPE##_or_not_##NAME(TYPE a, TYPE b) \
{ \
  union U ua, ub; \
  int actual, expected, i; \
  ua._##TYPE = a; \
  ub._##TYPE = b; \
  actual = (a OP b) || !(a OP b); \
  expected = 1; \
  for (i = 0; i < 4; i++) \
    expected &= (ua.TYPE##_a[i] OP ub.TYPE##_a[i]); \
  expected = expected || !expected; \
  if (actual != expected) \
  { \
    printf ("actual %d expected %d\n", actual, expected); \
    for (i = 0; i < 4; i++) \
      printf ("%d " #OP " %d = %d\n", ua.TYPE##_a[i], ub.TYPE##_a[i], (ua.TYPE##_a[i] OP ub.TYPE##_a[i])); \
  } \
  return actual == expected; \
}  \
void \
test_##TYPE##_or_not_##NAME() \
{ \
  TYPE a = {0, 0, 0, 0}; \
  TYPE b = {0, 0, 1, 1}; \
  TYPE c = {1, 1, 1, 1}; \
  if (!do_##TYPE##_or_not_##NAME(a,a)) FAIL; \
  if (!do_##TYPE##_or_not_##NAME(a,b)) FAIL; \
  if (!do_##TYPE##_or_not_##NAME(a,c)) FAIL; \
  if (!do_##TYPE##_or_not_##NAME(b,b)) FAIL; \
  if (!do_##TYPE##_or_not_##NAME(b,c)) FAIL; \
  if (!do_##TYPE##_or_not_##NAME(c,c)) FAIL; \
}

#define DEFINE_TESTS(TYPE) \
TEST_RELATIONAL(TYPE,eq,==) \
TEST_RELATIONAL(TYPE,ne,!=) \
TEST_RELATIONAL(TYPE,lt,<) \
TEST_RELATIONAL(TYPE,gt,>) \
TEST_RELATIONAL(TYPE,le,<=) \
TEST_RELATIONAL(TYPE,ge,>=) \
TEST_NOT_RELATIONAL(TYPE,eq,==) \
TEST_NOT_RELATIONAL(TYPE,ne,!=) \
TEST_NOT_RELATIONAL(TYPE,lt,<) \
TEST_NOT_RELATIONAL(TYPE,gt,>) \
TEST_NOT_RELATIONAL(TYPE,le,<=) \
TEST_NOT_RELATIONAL(TYPE,ge,>=) \
TEST_AND_NOT_RELATIONAL(TYPE,eq,==) \
TEST_AND_NOT_RELATIONAL(TYPE,ne,!=) \
TEST_AND_NOT_RELATIONAL(TYPE,lt,<) \
TEST_AND_NOT_RELATIONAL(TYPE,gt,>) \
TEST_AND_NOT_RELATIONAL(TYPE,le,<=) \
TEST_AND_NOT_RELATIONAL(TYPE,ge,>=) \
TEST_OR_NOT_RELATIONAL(TYPE,eq,==) \
TEST_OR_NOT_RELATIONAL(TYPE,ne,!=) \
TEST_OR_NOT_RELATIONAL(TYPE,lt,<) \
TEST_OR_NOT_RELATIONAL(TYPE,gt,>) \
TEST_OR_NOT_RELATIONAL(TYPE,le,<=) \
TEST_OR_NOT_RELATIONAL(TYPE,ge,>=)

#define CALL_TESTS(TYPE) \
  test_##TYPE##_eq(); \
  test_##TYPE##_ne(); \
  test_##TYPE##_lt(); \
  test_##TYPE##_gt(); \
  test_##TYPE##_le(); \
  test_##TYPE##_ge(); \
  test_##TYPE##_not_eq(); \
  test_##TYPE##_not_ne(); \
  test_##TYPE##_not_lt(); \
  test_##TYPE##_not_gt(); \
  test_##TYPE##_not_le(); \
  test_##TYPE##_not_ge(); \
  test_##TYPE##_and_not_eq(); \
  test_##TYPE##_and_not_ne(); \
  test_##TYPE##_and_not_lt(); \
  test_##TYPE##_and_not_gt(); \
  test_##TYPE##_and_not_le(); \
  test_##TYPE##_and_not_ge(); \
  test_##TYPE##_or_not_eq(); \
  test_##TYPE##_or_not_ne(); \
  test_##TYPE##_or_not_lt(); \
  test_##TYPE##_or_not_gt(); \
  test_##TYPE##_or_not_le(); \
  test_##TYPE##_or_not_ge();

DEFINE_TESTS(vsi4)
DEFINE_TESTS(vui4)
DEFINE_TESTS(vf4)

extern void exit (int);
extern void abort (void);

int
main()
{
  CALL_TESTS(vsi4)
  CALL_TESTS(vui4)
  CALL_TESTS(vf4)

  if (fail > 0)
    abort();
  exit (0);
}
