typedef struct _RenderInfo RenderInfo;
struct _RenderInfo
{
    int y;
    float scaley;
    int src_y;
};

static void bar(void) { }

static int
render_image_rgb_a (RenderInfo * info)
{
  int y, ye;
  float error;
  float step;

  y = info->y;
  ye = 256;

/* CELL LOCAL Begin */
#ifdef SPU_FDIV_PRECISION_BUG
  step = 1.0;	/* single precision division is not accurate on SPU */
#else
  step = 1.0 / info->scaley;
#endif
/* CELL LOCAL End */

  error = y * step;
  error -= ((int) error) - step;

  for (; y < ye; y++) {
      if (error >= 1.0) {
	  info->src_y += (int) error;
	  error -= (int) error;
	  bar();
      }
      error += step;
  }
  return info->src_y;
}

int main (void)
{
    RenderInfo info;

    info.y = 0;
    info.src_y = 0;
    info.scaley = 1.0;

    if (render_image_rgb_a(&info) != 256)
       abort ();
    exit(0);
}
