;;; This file is part of Cedilla.
;;; Copyright (C) 2002 by Juliusz Chroboczek.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.

(in-package "CEDILLA")

(eval-when (compile eval)
  (setup-cedilla-readtable))

(defun zapf-dingbats-encoding (char)
  (let ((code (and (characterp char) (char-code char))))
    (list
     (cond
       ((null code) nil)
       ((= code #x20) "space")
       ((or (< code #x2192) (> code #x27BE)) nil)
       (t (case code
            ;; This table contains the Unicode 3.2 mappings rather
            ;; than PUA mappings
            ((#x275E) "a100")
            ((#x2761) "a101")
            ((#x2762) "a102")
            ((#x2763) "a103")
            ((#x2764) "a104")
            ((#x2710) "a105")
            ((#x2765) "a106")
            ((#x2766) "a107")
            ((#x2767) "a108")
            ((#x2660) "a109")
            ((#x2721) "a10")
            ((#x2665) "a110")
            ((#x2666) "a111")
            ((#x2663) "a112")
            ((#x2709) "a117")
            ((#x2708) "a118")
            ((#x2707) "a119")
            ((#x261B) "a11")
            ((#x2460) "a120")
            ((#x2461) "a121")
            ((#x2462) "a122")
            ((#x2463) "a123")
            ((#x2464) "a124")
            ((#x2465) "a125")
            ((#x2466) "a126")
            ((#x2467) "a127")
            ((#x2468) "a128")
            ((#x2469) "a129")
            ((#x261E) "a12")
            ((#x2776) "a130")
            ((#x2777) "a131")
            ((#x2778) "a132")
            ((#x2779) "a133")
            ((#x277A) "a134")
            ((#x277B) "a135")
            ((#x277C) "a136")
            ((#x277D) "a137")
            ((#x277E) "a138")
            ((#x277F) "a139")
            ((#x270C) "a13")
            ((#x2780) "a140")
            ((#x2781) "a141")
            ((#x2782) "a142")
            ((#x2783) "a143")
            ((#x2784) "a144")
            ((#x2785) "a145")
            ((#x2786) "a146")
            ((#x2787) "a147")
            ((#x2788) "a148")
            ((#x2789) "a149")
            ((#x270D) "a14")
            ((#x278A) "a150")
            ((#x278B) "a151")
            ((#x278C) "a152")
            ((#x278D) "a153")
            ((#x278E) "a154")
            ((#x278F) "a155")
            ((#x2790) "a156")
            ((#x2791) "a157")
            ((#x2792) "a158")
            ((#x2793) "a159")
            ((#x270E) "a15")
            ((#x2794) "a160")
            ((#x2192) "a161")
            ((#x27A3) "a162")
            ((#x2194) "a163")
            ((#x2195) "a164")
            ((#x2799) "a165")
            ((#x279B) "a166")
            ((#x279C) "a167")
            ((#x279D) "a168")
            ((#x279E) "a169")
            ((#x270F) "a16")
            ((#x279F) "a170")
            ((#x27A0) "a171")
            ((#x27A1) "a172")
            ((#x27A2) "a173")
            ((#x27A4) "a174")
            ((#x27A5) "a175")
            ((#x27A6) "a176")
            ((#x27A7) "a177")
            ((#x27A8) "a178")
            ((#x27A9) "a179")
            ((#x2711) "a17")
            ((#x27AB) "a180")
            ((#x27AD) "a181")
            ((#x27AF) "a182")
            ((#x27B2) "a183")
            ((#x27B3) "a184")
            ((#x27B5) "a185")
            ((#x27B8) "a186")
            ((#x27BA) "a187")
            ((#x27BB) "a188")
            ((#x27BC) "a189")
            ((#x2712) "a18")
            ((#x27BD) "a190")
            ((#x27BE) "a191")
            ((#x279A) "a192")
            ((#x27AA) "a193")
            ((#x27B6) "a194")
            ((#x27B9) "a195")
            ((#x2798) "a196")
            ((#x27B4) "a197")
            ((#x27B7) "a198")
            ((#x27AC) "a199")
            ((#x2713) "a19")
            ((#x2701) "a1")
            ((#x27AE) "a200")
            ((#x27B1) "a201")
            ((#x2703) "a202")
            ((#x2750) "a203")
            ((#x2752) "a204")
            ((#x276E) "a205")
            ((#x2770) "a206")
            ((#x2714) "a20")
            ((#x2715) "a21")
            ((#x2716) "a22")
            ((#x2717) "a23")
            ((#x2718) "a24")
            ((#x2719) "a25")
            ((#x271A) "a26")
            ((#x271B) "a27")
            ((#x271C) "a28")
            ((#x2722) "a29")
            ((#x2702) "a2")
            ((#x2723) "a30")
            ((#x2724) "a31")
            ((#x2725) "a32")
            ((#x2726) "a33")
            ((#x2727) "a34")
            ((#x2605) "a35")
            ((#x2729) "a36")
            ((#x272A) "a37")
            ((#x272B) "a38")
            ((#x272C) "a39")
            ((#x2704) "a3")
            ((#x272D) "a40")
            ((#x272E) "a41")
            ((#x272F) "a42")
            ((#x2730) "a43")
            ((#x2731) "a44")
            ((#x2732) "a45")
            ((#x2733) "a46")
            ((#x2734) "a47")
            ((#x2735) "a48")
            ((#x2736) "a49")
            ((#x260E) "a4")
            ((#x2737) "a50")
            ((#x2738) "a51")
            ((#x2739) "a52")
            ((#x273A) "a53")
            ((#x273B) "a54")
            ((#x273C) "a55")
            ((#x273D) "a56")
            ((#x273E) "a57")
            ((#x273F) "a58")
            ((#x2740) "a59")
            ((#x2706) "a5")
            ((#x2741) "a60")
            ((#x2742) "a61")
            ((#x2743) "a62")
            ((#x2744) "a63")
            ((#x2745) "a64")
            ((#x2746) "a65")
            ((#x2747) "a66")
            ((#x2748) "a67")
            ((#x2749) "a68")
            ((#x274A) "a69")
            ((#x271D) "a6")
            ((#x274B) "a70")
            ((#x25CF) "a71")
            ((#x274D) "a72")
            ((#x25A0) "a73")
            ((#x274F) "a74")
            ((#x2751) "a75")
            ((#x25B2) "a76")
            ((#x25BC) "a77")
            ((#x25C6) "a78")
            ((#x2756) "a79")
            ((#x271E) "a7")
            ((#x25D7) "a81")
            ((#x2758) "a82")
            ((#x2759) "a83")
            ((#x275A) "a84")
            ((#x276F) "a85")
            ((#x2771) "a86")
            ((#x2772) "a87")
            ((#x2773) "a88")
            ((#x2768) "a89")
            ((#x271F) "a8")
            ((#x2769) "a90")
            ((#x276C) "a91")
            ((#x276D) "a92")
            ((#x276A) "a93")
            ((#x276B) "a94")
            ((#x2774) "a95")
            ((#x2775) "a96")
            ((#x275B) "a97")
            ((#x275C) "a98")
            ((#x275D) "a99")
            ((#x2720) "a9")
            (t nil)))))))

(defun iso-8859-7-fixed-encoding (ccs)
  (let* ((char (or (gethash ccs *ccs-precomposed*) ccs))
         (code (and (characterp char) (char-code char))))
    (cond
      ((null code) nil)
      ((= code #x2018) #xA1)
      ((= code #x2019) #xA2)
      ((member code '(#xA1 #xA2)) nil)
      ((or (<= code #xB3) (member code '(#xB7 #xBB #xBD)))
       code)
      ((member code '(#x387 #x38B #x38D)) nil)
      ((<= #x384 code #x3CE) (- code (- #x384 #xB4)))
      (t nil))))

(defun iso-8859-7-fake-encoding (char)
  (let ((index (iso-8859-7-fixed-encoding char)))
    (and index
         (car (ccs-glyph-names (normalise-ccs (code-char index)))))))


(eval-when (load eval compile)
(defvar *omega-glyph-names* (make-hash-table :test 'equal))
)

(eval-when (load eval)
(flet ((frob (x y) (setf (gethash x *omega-glyph-names*) y)))
  ;; Omega Serif Common
  (frob '#u00B7 "bullet")
  (frob '#u203F "undertie")
  (frob '#u2040 "tie")
  (frob '#u2116 "numero")
  (frob '#u20A0 "eurocurrency")
  (frob '#u20A1 "coloncurrency")
  (frob '#u20A2 "cruzeiro")
  (frob '#u20A3 "franc")
  (frob '#u20A4 "lira")
  (frob '#u20A5 "mill")
  (frob '#u20A6 "naira")
  (frob '#u20A7 "pesetas")
  (frob '#u20A9 "won")
  (frob '#u300 "gravenosp")
  (frob '#u301 "acutenosp")
  (frob '#u302 "circumflexnosp")
  (frob '#u303 "tildenosp")
  (frob '#u304 "macronnosp")
  (frob '#u305 "overscorenosp")
  (frob '#u306 "brevenosp")
  (frob '#u307 "dotnosp")
  (frob '#u308 "dieresisnosp")
  (frob '#u309 "hooksupnosp")
  (frob '#u30A "ringnosp")
  (frob '#u30B "acutedblnosp")
  (frob '#u30C "caronnosp")
  (frob '#u30D "linevertnosp")
  (frob '#u30E "linevertdblnosp")
  (frob '#u30F "gravedblnosp")
  (frob '#u310 "candrabindunosp")
  (frob '#u311 "breveinvnosp")
  (frob '#u312 "commaturnsupnosp")
  (frob '#u313 "commasupnosp")
  (frob '#u314 "commasuprevnosp")
  (frob '#u315 "commasuprightnosp")
  (frob '#u316 "gravesubnosp")
  (frob '#u317 "acutesubnosp")
  (frob '#u318 "tackleftsubnosp")
  (frob '#u319 "tesubnosp")
  (frob '#u31A "anglesupnosp")
  (frob '#u31B "hornnosp")
  (frob '#u31C "ringlefthalfsubnosp")
  (frob '#u31D "tackupsubnosp")
  (frob '#u31E "tackdownsubnosp")
  (frob '#u31F "plussubnosp")
  (frob '#u320 "minussubnosp")
  (frob '#u321 "hooksubpalatnosp")
  (frob '#u322 "hooksubretronosp")
  (frob '#u323 "dotsubnosp")
  (frob '#u324 "dotdblsubnosp")
  (frob '#u325 "ringsubnosp")
  (frob '#u326 "commasubnosp")
  (frob '#u327 "cedillanosp")
  (frob '#u328 "ogoneknosp")
  (frob '#u329 "linevertsubnosp")
  (frob '#u32A "bridgesubnosp")
  (frob '#u32B "archdblsubnosp")
  (frob '#u32C "haceksubnosp")
  (frob '#u32D "circumflexsubnosp")
  (frob '#u32E "brevesubnosp")
  (frob '#u32F "breveinvsubnosp")
  (frob '#u330 "tildesubnosp")
  (frob '#u331 "macronsubnosp")
  (frob '#u332 "underscorenosp")
  (frob '#u333 "underscoredblnosp")
  (frob '#u334 "tildemidnosp")
  (frob '#u335 "barmidshortnosp")
  (frob '#u336 "barmidlongnosp")
  (frob '#u337 "slashshortnosp")
  (frob '#u338 "slashlongnosp")
  (frob '#u339 "ringrighthalfsubnosp")
  (frob '#u33A "bridgeinvsubnosp")
  (frob '#u33B "squaresubnosp")
  (frob '#u33C "seagullsubnosp")
  (frob '#u33D "xsupnosp")
  (frob '#u33E "tildevertsupnosp")
  (frob '#u33F "overscoredblnosp")
  (frob '#u360 "combiningdoubletilde")
  (frob '#u361 "combiningdoubleinvertedbreve")
  ;; Omega Latin
  (frob '(#U301 . #U302) "circumflexacutenosp")
  (frob '(#U300 . #U302) "circumflexgravenosp")
  (frob '(#U309 . #U302) "circumflexhooknosp")
  (frob '(#U303 . #U306) "brevetildenosp")
  (frob '(#U301 . #U306) "breveacutenosp")
  (frob '(#U300 . #U306) "brevegravenosp")
  (frob '(#U309 . #U306) "brevehooknosp")
  (frob '(#U303 . #U306) "brevetildenosp")
  ;; Omega Cyrillic
  (frob '#u402 "Dje")
  (frob '#u404 "Ecyril")
  (frob '#u405 "Dze")
  (frob '#u406 "Icyril")
  (frob '#u408 "Je")
  (frob '#u409 "Lje")
  (frob '#u40A "Nje")
  (frob '#u40B "Tshe")
  (frob '#u429 "Shcha")
  (frob '#u40F "Dzhe")
  (frob '#u460 "Omegacyril")
  (frob '#u464 "Eiotified")
  (frob '#u466 "Yus")
  (frob '#u468 "Yusiotified")
  (frob '#u46A "Yusbig")
;  (frob '#u400 "dotlessicyril")
  (frob '#u452 "dje")
  (frob '#u454 "ecyril")
  (frob '#u455 "dze")
  (frob '#u456 "icyril")
  (frob '#u458 "je")
  (frob '#u459 "lje")
  (frob '#u45A "nje")
  (frob '#u45B "tshe")
  (frob '#u449 "shcha")
  (frob '#u45F "dzhe")
  (frob '#u461 "omegacyril")
  (frob '#u465 "eiotified")
  (frob '#u467 "yus")
  (frob '#u469 "yusiotified")
  (frob '#u46B "yusbig")
  (frob '#u42F "Ia")
  (frob '#u410 "Acyril")
  (frob '#u411 "Be")
  (frob '#u426 "Tse")
  (frob '#u414 "De")
  (frob '#u415 "Ie")
  (frob '#u424 "Ef")
  (frob '#u413 "Ge")
  (frob '#u42E "Iu")
  (frob '#u418 "Ii")
  (frob '#u416 "Zhe")
  (frob '#u41A "Ka")
  (frob '#u41B "El")
  (frob '#u41C "Em")
  (frob '#u41D "En")
  (frob '#u41E "Ocyril")
  (frob '#u41F "Pecyril")
  (frob '#u427 "Che")
  (frob '#u420 "Er")
  (frob '#u421 "Es")
  (frob '#u422 "Te")
  (frob '#u423 "Ucyril")
  (frob '#u412 "Ve")
  (frob '#u428 "Sha")
  (frob '#u425 "Kha")
  (frob '#u42B "Yeri")
  (frob '#u417 "Ze")
  (frob '#u42A "Hard")
  (frob '#u462 "Yat")
  (frob '#u42C "Soft")
  (frob '#u42D "Ecyrilrev")
  (frob '#u482 "thousandscyril")
  (frob '#u44F "ia")
  (frob '#u430 "acyril")
  (frob '#u431 "be")
  (frob '#u446 "tse")
  (frob '#u434 "de")
  (frob '#u435 "ie")
  (frob '#u444 "ef")
  (frob '#u433 "ge")
  (frob '#u44E "iu")
  (frob '#u438 "ii")
  (frob '#u436 "zhe")
  (frob '#u43A "ka")
  (frob '#u43B "el")
  (frob '#u43C "em")
  (frob '#u43D "en")
  (frob '#u43E "ocyril")
  (frob '#u43F "pecyril")
  (frob '#u447 "che")
  (frob '#u440 "er")
  (frob '#u441 "es")
  (frob '#u442 "te")
  (frob '#u443 "ucyril")
  (frob '#u432 "ve")
  (frob '#u448 "sha")
  (frob '#u445 "kha")
  (frob '#u44B "yeri")
  (frob '#u437 "ze")
  (frob '#u44A "hard")
  (frob '#u463 "yat")
  (frob '#u44C "soft")
  (frob '#u44D "ecyrilrev")
  (frob '#u492 "Gebarvar")
  (frob '#u46C "Yusbigiotified")
  (frob '#u46D "yusbigiotified")
  (frob '#u490 "Geupturn")
  (frob '#u491 "geupturn")
  (frob '#u472 "Fita")
  (frob '#u473 "fita")
  (frob '#u474 "Izhitsa")
  (frob '#u475 "izhitsa")
  (frob '#u47A "Omegaround")
  (frob '#u47B "omegaround")
  (frob '#u47C "Omegatitlo")
  (frob '#u47D "omegatitlo")
  (frob '#u47E "OT")
  (frob '#u47F "ot")
  (frob '#u480 "Koppacyril")
  (frob '#u481 "koppacyril")
  (frob '#u483 "titlo")
  (frob '#u46E "Ksicyril")
  (frob '#u46F "ksicyril")
  (frob '#u470 "Psicyril")
  (frob '#u471 "psicyril")
  (frob '#u492 "Gebar")
  (frob '#u493 "gebar")
  (frob '#u494 "Gehook")
  (frob '#u495 "gehook")
  (frob '#u496 "Zhertdes")
  (frob '#u497 "zhertdes")
  (frob '#u498 "Kartdes")
  (frob '#u499 "kartdes")
  (frob '#u49A "Kavertbar")
  (frob '#u49B "kavertbar")
  (frob '#u49E "Kabar")
  (frob '#u49F "kabar")
#|
  (frob '#u400 "gebarvar")
  (frob '#u400 "GeKarev")
  (frob '#u400 "Enrtdes")
  (frob '#u400 "EnGe")
  (frob '#u400 "Pehook")
  (frob '#u400 "Ohook")
  (frob '#u400 "Tertdes")
  (frob '#u400 "Ustrt")
  (frob '#u400 "Ustrtbar")
  (frob '#u400 "Khartdes")
  (frob '#u400 "TeTse")
  (frob '#u400 "Chertdes")
  (frob '#u400 "Chevertbar")
  (frob '#u400 "Hcyril")
  (frob '#u400 "Iehook")
  (frob '#u400 "Kahook")
  (frob '#u400 "gekarev")
  (frob '#u400 "enrtdes")
  (frob '#u400 "enge")
  (frob '#u400 "pehook")
  (frob '#u400 "ohook")
  (frob '#u400 "tertdes")
  (frob '#u400 "ustrt")
  (frob '#u400 "ustrtbar")
  (frob '#u400 "khartdes")
  (frob '#u400 "tetse")
  (frob '#u400 "chertdes")
  (frob '#u400 "chevertbar")
  (frob '#u400 "hcyril")
  (frob '#u400 "iehook")
  (frob '#u400 "kahook")
  (frob '#u400 "Enhook")
  (frob '#u400 "Cheleftdes")
  (frob '#u400 "AE")
  (frob '#u400 "Schwa")
  (frob '#u400 "Yogh")
  (frob '#u400 "Obarcyril")
  (frob '#u400 "Zeogonek")
  (frob '#u400 "Iehookogonek")
  (frob '#u400 "Esogonek")
  (frob '#u400 "Oogonek")
  (frob '#u400 "enhook")
  (frob '#u400 "cheleftdes")
  (frob '#u400 "ae")
  (frob '#u400 "schwa")
  (frob '#u400 "yogh")
  (frob '#u400 "obarcyril")
  (frob '#u400 "zeogonek")
  (frob '#u400 "iehookogonek")
  (frob '#u400 "esogonek")
  (frob '#u400 "oogonek")
  (frob '#u400 "acutenosp")
  (frob '#u400 "dieresisnosp")
  (frob '#u400 "gravedblnosp")
  (frob '#u400 "brevenosp")
  (frob '#u400 "acutedblnosp")
  (frob '#u400 "macronnosp")
  (frob '#u400 "palatalcyril")
  (frob '#u400 "psilicyril")
  (frob '#u400 "dasiacyril")
  (frob '#u400 "brevecyril")
|#
  ;; Omega Serif Greek
  (frob '#u342 "perispomeni")
  (frob '#u1FDD "dasiavaria")
  (frob '#u1FDE "dasiaoxia")
  (frob '#u1FDF "dasiaperispomeni")
  (frob '#u1FCD "psilivaria")
  (frob '#u1FCE "psilioxia")
  (frob '#u1FCF "psiliperispomeni")
  (frob '#u345 "upogegrammeni")
;;(frob '#u1FBE "prosgegrammeni")
  (frob '#u1FED "dieresisvaria")
  (frob '#u1FEE "dieresisoxia")
  (frob '#u1FC1 "dieresisperispomeni")
  (frob '#u3C2 "sigmafinal")
))

(defun omega-encoding (ccs)
  (let ((name (gethash ccs *omega-glyph-names*)))
    (if name (list name) (ccs-glyph-names ccs))))
