#ifndef H_CDW_CHECKBOX
#define H_CDW_CHECKBOX


#include "cdw_ncurses.h"

typedef struct {
	WINDOW *parent;  /* parent window of the widget */
	int begin_y;
	int begin_x;
	bool checked;    /* state of the checkbox */
	bool visible;    /* widget may be present, but invisible to the user, and "not-visitable" */

	cdw_form_widget_function_t on_toggle;   /* callback */
} CDW_CHECKBOX;




CDW_CHECKBOX *cdw_checkbox_new(WINDOW *parent, int begin_y, int begin_x, bool checked);
void cdw_checkbox_delete(CDW_CHECKBOX **checkbox);
void cdw_checkbox_free(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_toggle(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_get_state(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_set_state(CDW_CHECKBOX *checkbox, bool checked);
void cdw_checkbox_set_visibility(CDW_CHECKBOX *checkbox, bool visible);
void cdw_checkbox_draw(CDW_CHECKBOX *checkbox);


#endif /* #ifndef H_CDW_CHECKBOX */
