/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

/*
** $Id: AmrDeriveIntScalLen_F.H,v 1.4 2003/01/08 22:36:21 marc Exp $
*/

#include <REAL.H>
#include <ArrayLim.H>

#ifdef BL_LANG_FORT
#  define   FORT_SCALLEN       scallen3d
#  define   FORT_TKE           tke3d
#  define   FORT_TI            ti3d
#  define   FORT_TAVG          tavg3d
#  define   FORT_GUS           gusqrd
#else

#  if defined(BL_FORT_USE_UPPERCASE)
#    define   FORT_SCALLEN       SCALLEN3D
#    define   FORT_TKE           TKE3D
#    define   FORT_TI            TI3D
#    define   FORT_TAVG          TAVG3D
#    define   FORT_GUS           GUSQRD
#  elif defined(BL_FORT_USE_LOWERCASE)
#    define   FORT_SCALLEN       scallen3d
#    define   FORT_TKE           tke3d
#    define   FORT_TI            ti3d
#    define   FORT_TAVG          tavg3d
#    define   FORT_GUS           gusqrd
#  elif defined(BL_FORT_USE_UNDERSCORE)
#    define   FORT_SCALLEN       scallen3d_
#    define   FORT_TKE           tke3d_
#    define   FORT_TI            ti3d_
#    define   FORT_TAVG          tavg3d_
#    define   FORT_GUS           gusqrd_
#  endif

//
// Use ARLIM in the following.
//

extern "C"
{
  void FORT_SCALLEN(const Real *u, 
		    const int &uloi1, const int &uloi2, const int &uloi3,
		    const int &uhii1, const int &uhii2, const int &uhii3,
		    const int &nvar,  const Real *dx,
		    const int *ovlo, const int *ovhi,
                    Real* TSL_z,
                    Real* corr, const int& corrSize,
                    Real* ug,
                    const int &uglo1, const int &uglo2, const int &uglo3,
                    const int &ughi1, const int &ughi2, const int &ughi3);

  void FORT_TKE(const Real *u, 
		    const int &uloi1, const int &uloi2, const int &uloi3,
		    const int &uhii1, const int &uhii2, const int &uhii3,
		    const int &nvar,  const Real *dx,
		    const int *ovlo, const int *ovhi,
			Real* TKE_z);

  void FORT_GUS(const Real *u, 
		    const int &uloi1, const int &uloi2, const int &uloi3,
		    const int &uhii1, const int &uhii2, const int &uhii3,
		    const int &nvar,  const Real *dx,
		    const int *ovlo, const int *ovhi,
			Real* GUS_z);

  void FORT_TI(const Real *u, 
		    const int &uloi1, const int &uloi2, const int &uloi3,
		    const int &uhii1, const int &uhii2, const int &uhii3,
		    const int &nvar,  const Real *dx,
		    const int *ovlo, const int *ovhi,
			Real* TI_z);

  void FORT_TAVG(const Real *T, 
		    const int &Tloi1, const int &Tloi2, const int &Tloi3,
		    const int &Thii1, const int &Thii2, const int &Thii3,
		    const int &nvar,  const Real *dx,
		    const int *ovlo, const int *ovhi,
			Real* TAVG_z);

}


#endif
