/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.3.6. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef CB2BIB_H
#define CB2BIB_H

#include "ui_cb2Bib.h"

#include <QHash>
#include <QMainWindow>
#include <QPointer>

class bibSearcher;
class c2bBibMenu;
class c2bBibParser;
class c2bCiter;
class c2bClipEdit;
class c2bClipboard;
class c2bEditor;
class c2bNetworkQuery;
class c2bPdfImport;
class c2bSearchInFiles;
class c2bSettings;
class c2bTextBrowser;


class cb2Bib : public QMainWindow
{

    Q_OBJECT

public:
    cb2Bib(QWidget* parentw = 0);
    ~cb2Bib();


public slots:
    void show();


signals:
    void addedBibToFile(const QString&);
    void endedProcessing(bool status);


private:
    QHash<QString, c2bEditor*> _openDocuments;
    QPointer<c2bPdfImport> _pdfImportP;
    QPointer<c2bSearchInFiles> _searchInFilesP;
    QString _dropped_document_file;
    QString _raw_input_data;
    QString _target_document_file;
    Ui::cb2Bib ui;
    bool _connected;
    bool _is_check_repeated_done;
    bool _modified;
    bool _taggedViewMode;
    bool isReferenceRepeated();
    c2bBibMenu* _bib_menu;
    c2bBibParser* _bpP;
    c2bCiter* _citerP;
    c2bClipEdit* BibBrowser;
    c2bClipEdit* ClipEdit;
    c2bClipboard* _cbP;
    c2bNetworkQuery* _netQP;
    c2bSettings* _settingsP;
    c2bTextBrowser* AboutBrowser;
    void c2bParse(const QString& text);
    void c2bPreparse(const QString& text);
    void closeEvent(QCloseEvent* qevent);
    void dragEnterEvent(QDragEnterEvent* qevent);
    void dropEvent(QDropEvent* qevent);
    void fileDroppedByUser(const QString& fn);
    void initAsBibTeXEditor();
    void processingEnded();
    void setBibMenu();
    void setWidgetMapping();
    void updateBibfile(const QString& fn);
    void updateViewButtons();


private slots:
    void abbreviationsEditor();
    void addAuthors();
    void addEditors();
    void addToFile(bool ready);
    void anyPattern();
    void bibEditor(const QString& bibtexfile, bibSearcher* searcher = 0);
    void bibModified(bool modified);
    void bookmarksEditor();
    void c2bInit();
    void checkRepeated();
    void dataChanged(const QString& str);
    void deleteTmpBib();
    void doSearchInFiles(const QString& string = QString(), const QString& fn = QString());
    void fileDropped(const QString& fn);
    void forceDataChange(const QString& str);
    void guessFields();
    void insertRegExp();
    void linkClicked(const QUrl& ln);
    void loadSettings();
    void makeNetQuery();
    void netQueryEnded(bool stat, const QString& targetPDF, const QString& targetBib);
    void on_PdfImportB_clicked();
    void on_addBibB_clicked();
    void on_configureB_clicked();
    void on_connectB_clicked();
    void on_editBibTeXB_clicked();
    void on_exitB_clicked();
    void on_file_dirs_clicked();
    void on_makeNetworkQueryB_clicked();
    void on_searchInFilesB_clicked();
    void on_viewAboutB_clicked();
    void on_viewBibB_clicked();
    void openAnnote();
    void openFileDocument();
    void postprocessBibTeX();
    void preparseClipboard();
    void readField(const QPoint& position);
    void regExpsEditor();
    void restartEngine();
    void savePattern(const QString& rx, const QString& rxname);
    void selectFile();
    void setDocumentFilename();
    void setTaggedClipEditMode(bool tagged);
    void setWindowTitle(const QString& title = QString());
    void showLink(const QString& ln);
    void showMessage(const QString& ms);
    void updateCheckRepeatedAction();
    void updateOpenDocuments(QObject* obj);
    void updateOpenDocuments(const QString& old_name, const QString& new_name);

};

#endif
