// Copyright (C) 2005-2008 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef CXX_HOME_ADERAM_SOFTWARES_CAMITK_NEW_CAMITKTIMC_CAMITK_TOOLS_MML_SCHEMA_MONITORING_MODEL_HXX
#define CXX_HOME_ADERAM_SOFTWARES_CAMITK_NEW_CAMITKTIMC_CAMITK_TOOLS_MML_SCHEMA_MONITORING_MODEL_HXX

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (XSD_INT_VERSION != 3020000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info < char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap < char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream < char > list_stream;
  typedef ::xsd::cxx::tree::as_double < double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal < decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::auto_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace mml
{
  class MonitoringIn;
  class TimeParameter;
  class TimeUnit;
  class StoppingCriteria;
  class Criteria;
  class KineticEnergy;
  class Speed;
  class SpeedUnit;
  class Position;
  class PositionUnit;
  class Time;
  class Force;
  class ForceUnit;
  class Method;
  class Threshold;
  class MinThreshold;
  class Scope;
  class MultipleCriteria;
  class LogicalOp;
  class Monitors;
  class Reference;
  class Monitor;
  class MonitorType;
  class MonitoringOut;
  class TimeStep;
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace mml
{
  class MonitoringIn: public ::xml_schema::type
  {
    public:
    // dt
    // 
    typedef ::mml::TimeParameter dt_type;
    typedef ::xsd::cxx::tree::traits< dt_type, char > dt_traits;

    const dt_type&
    dt () const;

    dt_type&
    dt ();

    void
    dt (const dt_type& x);

    void
    dt (::std::auto_ptr< dt_type > p);

    // refresh
    // 
    typedef ::mml::TimeParameter refresh_type;
    typedef ::xsd::cxx::tree::traits< refresh_type, char > refresh_traits;

    const refresh_type&
    refresh () const;

    refresh_type&
    refresh ();

    void
    refresh (const refresh_type& x);

    void
    refresh (::std::auto_ptr< refresh_type > p);

    // pmlFile
    // 
    typedef ::xml_schema::string pmlFile_type;
    typedef ::xsd::cxx::tree::optional< pmlFile_type > pmlFile_optional;
    typedef ::xsd::cxx::tree::traits< pmlFile_type, char > pmlFile_traits;

    const pmlFile_optional&
    pmlFile () const;

    pmlFile_optional&
    pmlFile ();

    void
    pmlFile (const pmlFile_type& x);

    void
    pmlFile (const pmlFile_optional& x);

    void
    pmlFile (::std::auto_ptr< pmlFile_type > p);

    // simulatorFile
    // 
    typedef ::xml_schema::string simulatorFile_type;
    typedef ::xsd::cxx::tree::optional< simulatorFile_type > simulatorFile_optional;
    typedef ::xsd::cxx::tree::traits< simulatorFile_type, char > simulatorFile_traits;

    const simulatorFile_optional&
    simulatorFile () const;

    simulatorFile_optional&
    simulatorFile ();

    void
    simulatorFile (const simulatorFile_type& x);

    void
    simulatorFile (const simulatorFile_optional& x);

    void
    simulatorFile (::std::auto_ptr< simulatorFile_type > p);

    // lmlFile
    // 
    typedef ::xml_schema::string lmlFile_type;
    typedef ::xsd::cxx::tree::optional< lmlFile_type > lmlFile_optional;
    typedef ::xsd::cxx::tree::traits< lmlFile_type, char > lmlFile_traits;

    const lmlFile_optional&
    lmlFile () const;

    lmlFile_optional&
    lmlFile ();

    void
    lmlFile (const lmlFile_type& x);

    void
    lmlFile (const lmlFile_optional& x);

    void
    lmlFile (::std::auto_ptr< lmlFile_type > p);

    // simulator
    // 
    typedef ::xml_schema::string simulator_type;
    typedef ::xsd::cxx::tree::traits< simulator_type, char > simulator_traits;

    const simulator_type&
    simulator () const;

    simulator_type&
    simulator ();

    void
    simulator (const simulator_type& x);

    void
    simulator (::std::auto_ptr< simulator_type > p);

    // stoppingCriteria
    // 
    typedef ::mml::StoppingCriteria stoppingCriteria_type;
    typedef ::xsd::cxx::tree::optional< stoppingCriteria_type > stoppingCriteria_optional;
    typedef ::xsd::cxx::tree::traits< stoppingCriteria_type, char > stoppingCriteria_traits;

    const stoppingCriteria_optional&
    stoppingCriteria () const;

    stoppingCriteria_optional&
    stoppingCriteria ();

    void
    stoppingCriteria (const stoppingCriteria_type& x);

    void
    stoppingCriteria (const stoppingCriteria_optional& x);

    void
    stoppingCriteria (::std::auto_ptr< stoppingCriteria_type > p);

    // monitors
    // 
    typedef ::mml::Monitors monitors_type;
    typedef ::xsd::cxx::tree::optional< monitors_type > monitors_optional;
    typedef ::xsd::cxx::tree::traits< monitors_type, char > monitors_traits;

    const monitors_optional&
    monitors () const;

    monitors_optional&
    monitors ();

    void
    monitors (const monitors_type& x);

    void
    monitors (const monitors_optional& x);

    void
    monitors (::std::auto_ptr< monitors_type > p);

    // Constructors.
    //
    MonitoringIn (const dt_type&,
                  const refresh_type&,
                  const simulator_type&);

    MonitoringIn (::std::auto_ptr< dt_type >&,
                  ::std::auto_ptr< refresh_type >&,
                  const simulator_type&);

    MonitoringIn (::std::auto_ptr< dt_type >&,
                  ::std::auto_ptr< refresh_type >&,
                  ::std::auto_ptr< simulator_type >&);

    MonitoringIn (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    MonitoringIn (const MonitoringIn& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual MonitoringIn*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MonitoringIn ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< dt_type > dt_;
    ::xsd::cxx::tree::one< refresh_type > refresh_;
    pmlFile_optional pmlFile_;
    simulatorFile_optional simulatorFile_;
    lmlFile_optional lmlFile_;
    ::xsd::cxx::tree::one< simulator_type > simulator_;
    stoppingCriteria_optional stoppingCriteria_;
    monitors_optional monitors_;
  };

  class TimeParameter: public ::xml_schema::type
  {
    public:
    // value
    // 
    typedef ::xml_schema::double_ value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char, ::xsd::cxx::tree::schema_type::double_ > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    // unit
    // 
    typedef ::mml::TimeUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    TimeParameter (const value_type&,
                   const unit_type&);

    TimeParameter (const ::xml_schema::type&,
                   const value_type&,
                   const unit_type&);

    TimeParameter (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TimeParameter (const TimeParameter& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual TimeParameter*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~TimeParameter ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< value_type > value_;
    ::xsd::cxx::tree::one< unit_type > unit_;
  };

  class TimeUnit: public ::xml_schema::string
  {
    public:
    enum value
    {
      ms,
      s,
      min
    };

    TimeUnit (value v);

    TimeUnit (const char* v);

    TimeUnit (const ::std::string& v);

    TimeUnit (const ::xml_schema::string& v);

    TimeUnit (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    TimeUnit (const ::xercesc::DOMAttr& a,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    TimeUnit (const ::std::string& s,
              const ::xercesc::DOMElement* e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    TimeUnit (const TimeUnit& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual TimeUnit*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TimeUnit&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_TimeUnit_convert ();
    }

    protected:
    value
    _xsd_TimeUnit_convert () const;

    public:
    static const char* const _xsd_TimeUnit_literals_[3];
    static const value _xsd_TimeUnit_indexes_[3];
  };

  class StoppingCriteria: public ::xml_schema::type
  {
    public:
    // criteria
    // 
    typedef ::mml::Criteria criteria_type;
    typedef ::xsd::cxx::tree::optional< criteria_type > criteria_optional;
    typedef ::xsd::cxx::tree::traits< criteria_type, char > criteria_traits;

    const criteria_optional&
    criteria () const;

    criteria_optional&
    criteria ();

    void
    criteria (const criteria_type& x);

    void
    criteria (const criteria_optional& x);

    void
    criteria (::std::auto_ptr< criteria_type > p);

    // multipleCriteria
    // 
    typedef ::mml::MultipleCriteria multipleCriteria_type;
    typedef ::xsd::cxx::tree::optional< multipleCriteria_type > multipleCriteria_optional;
    typedef ::xsd::cxx::tree::traits< multipleCriteria_type, char > multipleCriteria_traits;

    const multipleCriteria_optional&
    multipleCriteria () const;

    multipleCriteria_optional&
    multipleCriteria ();

    void
    multipleCriteria (const multipleCriteria_type& x);

    void
    multipleCriteria (const multipleCriteria_optional& x);

    void
    multipleCriteria (::std::auto_ptr< multipleCriteria_type > p);

    // Constructors.
    //
    StoppingCriteria ();

    StoppingCriteria (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    StoppingCriteria (const StoppingCriteria& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual StoppingCriteria*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~StoppingCriteria ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    criteria_optional criteria_;
    multipleCriteria_optional multipleCriteria_;
  };

  class Criteria: public ::xml_schema::type
  {
    public:
    // method
    // 
    typedef ::mml::Method method_type;
    typedef ::xsd::cxx::tree::traits< method_type, char > method_traits;

    const method_type&
    method () const;

    method_type&
    method ();

    void
    method (const method_type& x);

    void
    method (::std::auto_ptr< method_type > p);

    // data
    // 
    typedef ::xml_schema::string data_type;
    typedef ::xsd::cxx::tree::optional< data_type > data_optional;
    typedef ::xsd::cxx::tree::traits< data_type, char > data_traits;

    const data_optional&
    data () const;

    data_optional&
    data ();

    void
    data (const data_type& x);

    void
    data (const data_optional& x);

    void
    data (::std::auto_ptr< data_type > p);

    // Constructors.
    //
    Criteria (const method_type&);

    Criteria (::std::auto_ptr< method_type >&);

    Criteria (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    Criteria (const Criteria& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual Criteria*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Criteria ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< method_type > method_;
    data_optional data_;
  };

  class KineticEnergy: public ::mml::Criteria
  {
    public:
    // Constructors.
    //
    KineticEnergy (const method_type&);

    KineticEnergy (::std::auto_ptr< method_type >&);

    KineticEnergy (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    KineticEnergy (const KineticEnergy& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual KineticEnergy*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~KineticEnergy ();
  };

  class Speed: public ::mml::Criteria
  {
    public:
    // unit
    // 
    typedef ::mml::SpeedUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    Speed (const method_type&,
           const unit_type&);

    Speed (::std::auto_ptr< method_type >&,
           const unit_type&);

    Speed (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Speed (const Speed& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    virtual Speed*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Speed ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< unit_type > unit_;
  };

  class SpeedUnit: public ::xml_schema::string
  {
    public:
    enum value
    {
      m_s
    };

    SpeedUnit (value v);

    SpeedUnit (const char* v);

    SpeedUnit (const ::std::string& v);

    SpeedUnit (const ::xml_schema::string& v);

    SpeedUnit (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    SpeedUnit (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    SpeedUnit (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    SpeedUnit (const SpeedUnit& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual SpeedUnit*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    SpeedUnit&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_SpeedUnit_convert ();
    }

    protected:
    value
    _xsd_SpeedUnit_convert () const;

    public:
    static const char* const _xsd_SpeedUnit_literals_[1];
    static const value _xsd_SpeedUnit_indexes_[1];
  };

  class Position: public ::mml::Criteria
  {
    public:
    // unit
    // 
    typedef ::mml::PositionUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    Position (const method_type&,
              const unit_type&);

    Position (::std::auto_ptr< method_type >&,
              const unit_type&);

    Position (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    Position (const Position& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual Position*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Position ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< unit_type > unit_;
  };

  class PositionUnit: public ::xml_schema::string
  {
    public:
    enum value
    {
      nm,
      mm
    };

    PositionUnit (value v);

    PositionUnit (const char* v);

    PositionUnit (const ::std::string& v);

    PositionUnit (const ::xml_schema::string& v);

    PositionUnit (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    PositionUnit (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    PositionUnit (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    PositionUnit (const PositionUnit& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual PositionUnit*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    PositionUnit&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_PositionUnit_convert ();
    }

    protected:
    value
    _xsd_PositionUnit_convert () const;

    public:
    static const char* const _xsd_PositionUnit_literals_[2];
    static const value _xsd_PositionUnit_indexes_[2];
  };

  class Time: public ::mml::Criteria
  {
    public:
    // unit
    // 
    typedef ::mml::TimeUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    Time (const method_type&,
          const unit_type&);

    Time (::std::auto_ptr< method_type >&,
          const unit_type&);

    Time (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    Time (const Time& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    virtual Time*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Time ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< unit_type > unit_;
  };

  class Force: public ::mml::Criteria
  {
    public:
    // unit
    // 
    typedef ::mml::ForceUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    Force (const method_type&,
           const unit_type&);

    Force (::std::auto_ptr< method_type >&,
           const unit_type&);

    Force (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Force (const Force& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    virtual Force*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Force ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< unit_type > unit_;
  };

  class ForceUnit: public ::xml_schema::string
  {
    public:
    enum value
    {
      mN,
      N
    };

    ForceUnit (value v);

    ForceUnit (const char* v);

    ForceUnit (const ::std::string& v);

    ForceUnit (const ::xml_schema::string& v);

    ForceUnit (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    ForceUnit (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    ForceUnit (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    ForceUnit (const ForceUnit& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual ForceUnit*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ForceUnit&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ForceUnit_convert ();
    }

    protected:
    value
    _xsd_ForceUnit_convert () const;

    public:
    static const char* const _xsd_ForceUnit_literals_[2];
    static const value _xsd_ForceUnit_indexes_[2];
  };

  class Method: public ::xml_schema::type
  {
    public:
    // scope
    // 
    typedef ::mml::Scope scope_type;
    typedef ::xsd::cxx::tree::optional< scope_type > scope_optional;
    typedef ::xsd::cxx::tree::traits< scope_type, char > scope_traits;

    const scope_optional&
    scope () const;

    scope_optional&
    scope ();

    void
    scope (const scope_type& x);

    void
    scope (const scope_optional& x);

    void
    scope (::std::auto_ptr< scope_type > p);

    // Constructors.
    //
    Method ();

    Method (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    Method (const Method& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual Method*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Method ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    scope_optional scope_;
  };

  class Threshold: public ::mml::Method
  {
    public:
    // maxValue
    // 
    typedef ::xml_schema::double_ maxValue_type;
    typedef ::xsd::cxx::tree::traits< maxValue_type, char, ::xsd::cxx::tree::schema_type::double_ > maxValue_traits;

    const maxValue_type&
    maxValue () const;

    maxValue_type&
    maxValue ();

    void
    maxValue (const maxValue_type& x);

    // Constructors.
    //
    Threshold (const maxValue_type&);

    Threshold (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    Threshold (const Threshold& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual Threshold*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Threshold ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< maxValue_type > maxValue_;
  };

  class MinThreshold: public ::mml::Method
  {
    public:
    // minValue
    // 
    typedef ::xml_schema::double_ minValue_type;
    typedef ::xsd::cxx::tree::traits< minValue_type, char, ::xsd::cxx::tree::schema_type::double_ > minValue_traits;

    const minValue_type&
    minValue () const;

    minValue_type&
    minValue ();

    void
    minValue (const minValue_type& x);

    // Constructors.
    //
    MinThreshold (const minValue_type&);

    MinThreshold (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    MinThreshold (const MinThreshold& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual MinThreshold*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MinThreshold ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< minValue_type > minValue_;
  };

  class Scope: public ::xml_schema::string
  {
    public:
    enum value
    {
      Any,
      Average,
      Sum
    };

    Scope (value v);

    Scope (const char* v);

    Scope (const ::std::string& v);

    Scope (const ::xml_schema::string& v);

    Scope (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Scope (const ::xercesc::DOMAttr& a,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Scope (const ::std::string& s,
           const ::xercesc::DOMElement* e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Scope (const Scope& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    virtual Scope*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Scope&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_Scope_convert ();
    }

    protected:
    value
    _xsd_Scope_convert () const;

    public:
    static const char* const _xsd_Scope_literals_[3];
    static const value _xsd_Scope_indexes_[3];
  };

  class MultipleCriteria: public ::xml_schema::type
  {
    public:
    // multipleCriteria
    // 
    typedef ::mml::MultipleCriteria multipleCriteria_type;
    typedef ::xsd::cxx::tree::sequence< multipleCriteria_type > multipleCriteria_sequence;
    typedef multipleCriteria_sequence::iterator multipleCriteria_iterator;
    typedef multipleCriteria_sequence::const_iterator multipleCriteria_const_iterator;
    typedef ::xsd::cxx::tree::traits< multipleCriteria_type, char > multipleCriteria_traits;

    const multipleCriteria_sequence&
    multipleCriteria () const;

    multipleCriteria_sequence&
    multipleCriteria ();

    void
    multipleCriteria (const multipleCriteria_sequence& s);

    // criteria
    // 
    typedef ::mml::Criteria criteria_type;
    typedef ::xsd::cxx::tree::sequence< criteria_type > criteria_sequence;
    typedef criteria_sequence::iterator criteria_iterator;
    typedef criteria_sequence::const_iterator criteria_const_iterator;
    typedef ::xsd::cxx::tree::traits< criteria_type, char > criteria_traits;

    const criteria_sequence&
    criteria () const;

    criteria_sequence&
    criteria ();

    void
    criteria (const criteria_sequence& s);

    // op
    // 
    typedef ::mml::LogicalOp op_type;
    typedef ::xsd::cxx::tree::traits< op_type, char > op_traits;

    const op_type&
    op () const;

    op_type&
    op ();

    void
    op (const op_type& x);

    void
    op (::std::auto_ptr< op_type > p);

    // Constructors.
    //
    MultipleCriteria (const op_type&);

    MultipleCriteria (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    MultipleCriteria (const MultipleCriteria& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual MultipleCriteria*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MultipleCriteria ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    multipleCriteria_sequence multipleCriteria_;
    criteria_sequence criteria_;
    ::xsd::cxx::tree::one< op_type > op_;
  };

  class LogicalOp: public ::xml_schema::string
  {
    public:
    enum value
    {
      And,
      Or
    };

    LogicalOp (value v);

    LogicalOp (const char* v);

    LogicalOp (const ::std::string& v);

    LogicalOp (const ::xml_schema::string& v);

    LogicalOp (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    LogicalOp (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    LogicalOp (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    LogicalOp (const LogicalOp& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual LogicalOp*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LogicalOp&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_LogicalOp_convert ();
    }

    protected:
    value
    _xsd_LogicalOp_convert () const;

    public:
    static const char* const _xsd_LogicalOp_literals_[2];
    static const value _xsd_LogicalOp_indexes_[2];
  };

  class Monitors: public ::xml_schema::type
  {
    public:
    // monitor
    // 
    typedef ::mml::Monitor monitor_type;
    typedef ::xsd::cxx::tree::sequence< monitor_type > monitor_sequence;
    typedef monitor_sequence::iterator monitor_iterator;
    typedef monitor_sequence::const_iterator monitor_const_iterator;
    typedef ::xsd::cxx::tree::traits< monitor_type, char > monitor_traits;

    const monitor_sequence&
    monitor () const;

    monitor_sequence&
    monitor ();

    void
    monitor (const monitor_sequence& s);

    // Constructors.
    //
    Monitors ();

    Monitors (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    Monitors (const Monitors& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual Monitors*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Monitors ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    monitor_sequence monitor_;
  };

  class Reference: public ::xml_schema::type
  {
    public:
    // document
    // 
    typedef ::xml_schema::string document_type;
    typedef ::xsd::cxx::tree::traits< document_type, char > document_traits;

    const document_type&
    document () const;

    document_type&
    document ();

    void
    document (const document_type& x);

    void
    document (::std::auto_ptr< document_type > p);

    // monitorIndex
    // 
    typedef ::xml_schema::non_negative_integer monitorIndex_type;
    typedef ::xsd::cxx::tree::optional< monitorIndex_type > monitorIndex_optional;
    typedef ::xsd::cxx::tree::traits< monitorIndex_type, char > monitorIndex_traits;

    const monitorIndex_optional&
    monitorIndex () const;

    monitorIndex_optional&
    monitorIndex ();

    void
    monitorIndex (const monitorIndex_type& x);

    void
    monitorIndex (const monitorIndex_optional& x);

    // target
    // 
    typedef ::xml_schema::string target_type;
    typedef ::xsd::cxx::tree::optional< target_type > target_optional;
    typedef ::xsd::cxx::tree::traits< target_type, char > target_traits;

    const target_optional&
    target () const;

    target_optional&
    target ();

    void
    target (const target_type& x);

    void
    target (const target_optional& x);

    void
    target (::std::auto_ptr< target_type > p);

    // Constructors.
    //
    Reference (const document_type&);

    Reference (const ::xml_schema::type&,
               const document_type&);

    Reference (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    Reference (const Reference& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual Reference*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Reference ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< document_type > document_;
    monitorIndex_optional monitorIndex_;
    target_optional target_;
  };

  class Monitor: public ::xml_schema::type
  {
    public:
    // startAt
    // 
    typedef ::mml::TimeParameter startAt_type;
    typedef ::xsd::cxx::tree::traits< startAt_type, char > startAt_traits;

    const startAt_type&
    startAt () const;

    startAt_type&
    startAt ();

    void
    startAt (const startAt_type& x);

    void
    startAt (::std::auto_ptr< startAt_type > p);

    // stopAt
    // 
    typedef ::mml::TimeParameter stopAt_type;
    typedef ::xsd::cxx::tree::traits< stopAt_type, char > stopAt_traits;

    const stopAt_type&
    stopAt () const;

    stopAt_type&
    stopAt ();

    void
    stopAt (const stopAt_type& x);

    void
    stopAt (::std::auto_ptr< stopAt_type > p);

    // reference
    // 
    typedef ::mml::Reference reference_type;
    typedef ::xsd::cxx::tree::sequence< reference_type > reference_sequence;
    typedef reference_sequence::iterator reference_iterator;
    typedef reference_sequence::const_iterator reference_const_iterator;
    typedef ::xsd::cxx::tree::traits< reference_type, char > reference_traits;

    const reference_sequence&
    reference () const;

    reference_sequence&
    reference ();

    void
    reference (const reference_sequence& s);

    // indexes
    // 
    typedef ::xml_schema::string indexes_type;
    typedef ::xsd::cxx::tree::optional< indexes_type > indexes_optional;
    typedef ::xsd::cxx::tree::traits< indexes_type, char > indexes_traits;

    const indexes_optional&
    indexes () const;

    indexes_optional&
    indexes ();

    void
    indexes (const indexes_type& x);

    void
    indexes (const indexes_optional& x);

    void
    indexes (::std::auto_ptr< indexes_type > p);

    // data
    // 
    typedef ::xml_schema::string data_type;
    typedef ::xsd::cxx::tree::optional< data_type > data_optional;
    typedef ::xsd::cxx::tree::traits< data_type, char > data_traits;

    const data_optional&
    data () const;

    data_optional&
    data ();

    void
    data (const data_type& x);

    void
    data (const data_optional& x);

    void
    data (::std::auto_ptr< data_type > p);

    // type
    // 
    typedef ::mml::MonitorType type_type;
    typedef ::xsd::cxx::tree::traits< type_type, char > type_traits;

    const type_type&
    type () const;

    type_type&
    type ();

    void
    type (const type_type& x);

    void
    type (::std::auto_ptr< type_type > p);

    // index
    // 
    typedef ::xml_schema::non_negative_integer index_type;
    typedef ::xsd::cxx::tree::traits< index_type, char > index_traits;

    const index_type&
    index () const;

    index_type&
    index ();

    void
    index (const index_type& x);

    // target
    // 
    typedef ::xml_schema::string target_type;
    typedef ::xsd::cxx::tree::traits< target_type, char > target_traits;

    const target_type&
    target () const;

    target_type&
    target ();

    void
    target (const target_type& x);

    void
    target (::std::auto_ptr< target_type > p);

    // dx
    // 
    typedef ::xml_schema::double_ dx_type;
    typedef ::xsd::cxx::tree::optional< dx_type > dx_optional;
    typedef ::xsd::cxx::tree::traits< dx_type, char, ::xsd::cxx::tree::schema_type::double_ > dx_traits;

    const dx_optional&
    dx () const;

    dx_optional&
    dx ();

    void
    dx (const dx_type& x);

    void
    dx (const dx_optional& x);

    // dy
    // 
    typedef ::xml_schema::double_ dy_type;
    typedef ::xsd::cxx::tree::optional< dy_type > dy_optional;
    typedef ::xsd::cxx::tree::traits< dy_type, char, ::xsd::cxx::tree::schema_type::double_ > dy_traits;

    const dy_optional&
    dy () const;

    dy_optional&
    dy ();

    void
    dy (const dy_type& x);

    void
    dy (const dy_optional& x);

    // dz
    // 
    typedef ::xml_schema::double_ dz_type;
    typedef ::xsd::cxx::tree::optional< dz_type > dz_optional;
    typedef ::xsd::cxx::tree::traits< dz_type, char, ::xsd::cxx::tree::schema_type::double_ > dz_traits;

    const dz_optional&
    dz () const;

    dz_optional&
    dz ();

    void
    dz (const dz_type& x);

    void
    dz (const dz_optional& x);

    // Constructors.
    //
    Monitor (const startAt_type&,
             const stopAt_type&,
             const type_type&,
             const index_type&,
             const target_type&);

    Monitor (::std::auto_ptr< startAt_type >&,
             ::std::auto_ptr< stopAt_type >&,
             const type_type&,
             const index_type&,
             const target_type&);

    Monitor (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Monitor (const Monitor& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Monitor*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~Monitor ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< startAt_type > startAt_;
    ::xsd::cxx::tree::one< stopAt_type > stopAt_;
    reference_sequence reference_;
    indexes_optional indexes_;
    data_optional data_;
    ::xsd::cxx::tree::one< type_type > type_;
    ::xsd::cxx::tree::one< index_type > index_;
    ::xsd::cxx::tree::one< target_type > target_;
    dx_optional dx_;
    dy_optional dy_;
    dz_optional dz_;
  };

  class MonitorType: public ::xml_schema::string
  {
    public:
    enum value
    {
      Position,
      REN,
      GeomDeviation,
      Force,
      PointSetDistance,
      PointFinalSetDistance,
      Volume,
      Surface,
      Displacement,
      NormDisplacement
    };

    MonitorType (value v);

    MonitorType (const char* v);

    MonitorType (const ::std::string& v);

    MonitorType (const ::xml_schema::string& v);

    MonitorType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MonitorType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MonitorType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MonitorType (const MonitorType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual MonitorType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    MonitorType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_MonitorType_convert ();
    }

    protected:
    value
    _xsd_MonitorType_convert () const;

    public:
    static const char* const _xsd_MonitorType_literals_[10];
    static const value _xsd_MonitorType_indexes_[10];
  };

  class MonitoringOut: public ::xml_schema::type
  {
    public:
    // pmlFile
    // 
    typedef ::xml_schema::string pmlFile_type;
    typedef ::xsd::cxx::tree::traits< pmlFile_type, char > pmlFile_traits;

    const pmlFile_type&
    pmlFile () const;

    pmlFile_type&
    pmlFile ();

    void
    pmlFile (const pmlFile_type& x);

    void
    pmlFile (::std::auto_ptr< pmlFile_type > p);

    // time
    // 
    typedef ::mml::TimeStep time_type;
    typedef ::xsd::cxx::tree::sequence< time_type > time_sequence;
    typedef time_sequence::iterator time_iterator;
    typedef time_sequence::const_iterator time_const_iterator;
    typedef ::xsd::cxx::tree::traits< time_type, char > time_traits;

    const time_sequence&
    time () const;

    time_sequence&
    time ();

    void
    time (const time_sequence& s);

    // Constructors.
    //
    MonitoringOut (const pmlFile_type&);

    MonitoringOut (::std::auto_ptr< pmlFile_type >&);

    MonitoringOut (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    MonitoringOut (const MonitoringOut& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual MonitoringOut*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MonitoringOut ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< pmlFile_type > pmlFile_;
    time_sequence time_;
  };

  class TimeStep: public ::xml_schema::type
  {
    public:
    // stoppingCriteria
    // 
    typedef ::mml::StoppingCriteria stoppingCriteria_type;
    typedef ::xsd::cxx::tree::optional< stoppingCriteria_type > stoppingCriteria_optional;
    typedef ::xsd::cxx::tree::traits< stoppingCriteria_type, char > stoppingCriteria_traits;

    const stoppingCriteria_optional&
    stoppingCriteria () const;

    stoppingCriteria_optional&
    stoppingCriteria ();

    void
    stoppingCriteria (const stoppingCriteria_type& x);

    void
    stoppingCriteria (const stoppingCriteria_optional& x);

    void
    stoppingCriteria (::std::auto_ptr< stoppingCriteria_type > p);

    // monitor
    // 
    typedef ::mml::Monitor monitor_type;
    typedef ::xsd::cxx::tree::sequence< monitor_type > monitor_sequence;
    typedef monitor_sequence::iterator monitor_iterator;
    typedef monitor_sequence::const_iterator monitor_const_iterator;
    typedef ::xsd::cxx::tree::traits< monitor_type, char > monitor_traits;

    const monitor_sequence&
    monitor () const;

    monitor_sequence&
    monitor ();

    void
    monitor (const monitor_sequence& s);

    // value
    // 
    typedef ::xml_schema::double_ value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char, ::xsd::cxx::tree::schema_type::double_ > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    // unit
    // 
    typedef ::mml::TimeUnit unit_type;
    typedef ::xsd::cxx::tree::traits< unit_type, char > unit_traits;

    const unit_type&
    unit () const;

    unit_type&
    unit ();

    void
    unit (const unit_type& x);

    void
    unit (::std::auto_ptr< unit_type > p);

    // Constructors.
    //
    TimeStep (const value_type&,
              const unit_type&);

    TimeStep (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    TimeStep (const TimeStep& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual TimeStep*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~TimeStep ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    stoppingCriteria_optional stoppingCriteria_;
    monitor_sequence monitor_;
    ::xsd::cxx::tree::one< value_type > value_;
    ::xsd::cxx::tree::one< unit_type > unit_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace mml
{
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace mml
{
  void
  operator<< (::xercesc::DOMElement&, const MonitoringIn&);

  void
  operator<< (::xercesc::DOMElement&, const TimeParameter&);

  void
  operator<< (::xercesc::DOMElement&, const TimeUnit&);

  void
  operator<< (::xercesc::DOMAttr&, const TimeUnit&);

  void
  operator<< (::xml_schema::list_stream&,
              const TimeUnit&);

  void
  operator<< (::xercesc::DOMElement&, const StoppingCriteria&);

  void
  operator<< (::xercesc::DOMElement&, const Criteria&);

  void
  operator<< (::xercesc::DOMElement&, const KineticEnergy&);

  void
  operator<< (::xercesc::DOMElement&, const Speed&);

  void
  operator<< (::xercesc::DOMElement&, const SpeedUnit&);

  void
  operator<< (::xercesc::DOMAttr&, const SpeedUnit&);

  void
  operator<< (::xml_schema::list_stream&,
              const SpeedUnit&);

  void
  operator<< (::xercesc::DOMElement&, const Position&);

  void
  operator<< (::xercesc::DOMElement&, const PositionUnit&);

  void
  operator<< (::xercesc::DOMAttr&, const PositionUnit&);

  void
  operator<< (::xml_schema::list_stream&,
              const PositionUnit&);

  void
  operator<< (::xercesc::DOMElement&, const Time&);

  void
  operator<< (::xercesc::DOMElement&, const Force&);

  void
  operator<< (::xercesc::DOMElement&, const ForceUnit&);

  void
  operator<< (::xercesc::DOMAttr&, const ForceUnit&);

  void
  operator<< (::xml_schema::list_stream&,
              const ForceUnit&);

  void
  operator<< (::xercesc::DOMElement&, const Method&);

  void
  operator<< (::xercesc::DOMElement&, const Threshold&);

  void
  operator<< (::xercesc::DOMElement&, const MinThreshold&);

  void
  operator<< (::xercesc::DOMElement&, const Scope&);

  void
  operator<< (::xercesc::DOMAttr&, const Scope&);

  void
  operator<< (::xml_schema::list_stream&,
              const Scope&);

  void
  operator<< (::xercesc::DOMElement&, const MultipleCriteria&);

  void
  operator<< (::xercesc::DOMElement&, const LogicalOp&);

  void
  operator<< (::xercesc::DOMAttr&, const LogicalOp&);

  void
  operator<< (::xml_schema::list_stream&,
              const LogicalOp&);

  void
  operator<< (::xercesc::DOMElement&, const Monitors&);

  void
  operator<< (::xercesc::DOMElement&, const Reference&);

  void
  operator<< (::xercesc::DOMElement&, const Monitor&);

  void
  operator<< (::xercesc::DOMElement&, const MonitorType&);

  void
  operator<< (::xercesc::DOMAttr&, const MonitorType&);

  void
  operator<< (::xml_schema::list_stream&,
              const MonitorType&);

  void
  operator<< (::xercesc::DOMElement&, const MonitoringOut&);

  void
  operator<< (::xercesc::DOMElement&, const TimeStep&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_HOME_ADERAM_SOFTWARES_CAMITK_NEW_CAMITKTIMC_CAMITK_TOOLS_MML_SCHEMA_MONITORING_MODEL_HXX
