/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#include "MeshComponent.h"
#include "InteractiveViewer.h"

//-- Qt stuff
#include <QMessageBox>
#include <QTextStream>
#include <QFileInfo>

//-- vtk stuff
#include <vtkPointSet.h>

namespace camitk {
// -------------------- constructor --------------------
MeshComponent::MeshComponent(const QString & file) throw(AbortException) : Component(file, "Mesh", Component::GEOMETRY) {
    pickedCellId = -1;
    pickedPointId = -1;
}

MeshComponent::MeshComponent(vtkSmartPointer<vtkPointSet> aPointSet, const QString &name) : Component("", name, Component::GEOMETRY) {
    initRepresentation(aPointSet);
    setModified();
}

MeshComponent::MeshComponent(Component *parentComponent, vtkSmartPointer<vtkPointSet> aPointSet, const QString &name) : Component(parentComponent, name, Component::GEOMETRY) {
    initRepresentation(aPointSet);
}

// -------------------- destructor --------------------
MeshComponent::~MeshComponent() {
}

// -------------------- initRepresentation --------------------
void MeshComponent::initRepresentation(vtkSmartPointer<vtkPointSet> originalPointSet) {
    pickedCellId = -1;
    pickedPointId = -1;
    // replace the point set
    if (myGeometry) {
        myGeometry->setPointSet(originalPointSet);
    }
    else {
        myGeometry = new Geometry(this->getName(), originalPointSet);
    }
    // add it in the InteractiveViewer (automatically)
    setVisibility(InteractiveViewer::get3DViewer(), true);
}

// -------------------- cellPicked --------------------
void MeshComponent::cellPicked(vtkIdType cellId, bool ) {
    pickedCellId = cellId;
}

// -------------------- pointPicked --------------------
void MeshComponent::pointPicked(vtkIdType pointId, bool ) {
    pickedPointId = pointId;
}

// -------------------- getPickedCellId --------------------
vtkIdType MeshComponent::getPickedCellId() {
    return pickedCellId;
}

// -------------------- getPickedPointId --------------------
vtkIdType MeshComponent::getPickedPointId() {
    return pickedPointId;
}


}
