/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef LOADSMOVIE_H
#define LOADSMOVIE_H

#include "ui_LoadsMovie.h"
#include <vector>

//class declared in this file
class LoadsMovie;
class LoadsManager;
class LoadsSimulationDriver;

/** This dialog allows to see the simulation
 * It plays the impload, allowing the user to see the evolution of translations along time.
 *
 */

class LoadsMovie : public QDialog {
    Q_OBJECT

  public:
    /**Default Constructor*/
    LoadsMovie(LoadsManager * myLoadsManager,  QWidget* parent = 0);

    /**Destructor*/
    ~LoadsMovie();

    /// get the actual time
    double getTime() const;

    /** update the display
     * @param force if true force display update independantly from refresh dt (default is false)
     */
    void updateDisplay(bool force);

  public slots :
    /// increment t and update the display
    void doOneStep();

    /**Slot called when the button Pause is clicked*/
    void pause();

    /**Slot called when the button Play is clicked*/
    void play();

    /**Slot called when the button Rewind is clicked*/
    void rewind();

    /**Slot called when the button Stop is clicked*/
    void stop();

    virtual void makeVideo();

    virtual void chooseOutputDir();

    virtual void tChanged();

    virtual void dtChanged();

    virtual void tMinChanged();

    virtual void tMaxChanged();

    virtual void defaultTMin();

    virtual void defaultTMax();

    virtual void tModified();

    virtual void dtModified();

    virtual void tMinModified();

    virtual void tMaxModified();

    virtual void tSliderChanged(int);

    virtual void playOneStep();

    virtual void reset();

  private :

    /// init display
    void init();

    /// the load manager
    LoadsManager * myLM;

    /// the initial bg color
    QColor bgColor;

    /// change the slider range/value depending on tmin, tmax and dt
    void initSlider();

    /// the output directory name for making videos
    QString outputDirName;

    /// the output dir name line edit
    QLineEdit * outputDirNameLineEdit;

    /// the code core for the display of a loads
    LoadsSimulationDriver * simDriver;

    /// the ui dialog designed in qtdesigner
    Ui::LoadsMovie ui;
};



#endif // LOADSMOVIE_H


