/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef LOADEDITOR_H
#define LOADEDITOR_H

#include "ui_LoadsEditor.h"
#include <Component.h>

class LoadsManager;
class Loads;
class Load;

/** A clean dialog to edit (add, modify, delete), loads and their parameters,
  * directly from Core

  */
class LoadsEditor : public QDialog {
Q_OBJECT
public:
    /// default constructor
    LoadsEditor(LoadsManager * myLoadsManager, QWidget* parent = 0);

    /// another constructor allowing for creating a new load for a particular atom dc
    LoadsEditor(std::vector <camitk::Component *> selectedDC, LoadsManager * myLoadsManager, QWidget* parent = 0);

    /// Destructor
    ~LoadsEditor();

    /// overloaded so that it can update the load list
    virtual void show();

    /// copy the loads from the manager to a local list
    void updateLoads();

public slots :

    /// when user click to add a new load
    void newLoad();

    /// when user click to delete current load
    void deleteLoad();

    /// when the user click on the load list
    void loadTableItemClicked(QTableWidgetItem *);

    /// when user has typed some text in the applyTo line edit
    void applyToTextChanged(const QString&);

    /// when user pressed return in the applyTo line edit
    void applyToReturnPressed();

    /// when user clicked on the applyTo button
    void applyToClicked();

    /// when user toggle null displacement
    void nullDisplacementClicked();

    /// when user changed the direction x
    void xChanged();

    /// when user changed the direction y
    void yChanged();

    /// when user changed the direction z
    void zChanged();

    /// when user changed the current unit
    void unitChanged();

    /// when user wants to add a new value event
    void newValueEvent();

    /// when user wants to delete current value event
    void deleteValueEvent();

    /// when user double clic on a value event
    void valueEventTableItemClicked(QTableWidgetItem *);

    /// when the user clic on reset, reset the loads (using load manager loads)
    void reset();

    /// when the user clic on cancel
    void reject();

    /// when the user clic on apply
    void apply();

private :

    /// initialize everything
    void init();

    /// refresh load list display
    void updateLoadsTable();

    /// refresh the value event display
    void updateValueEventTable();

    /// create a new load using this DC as targets
    void createDCLoads(std::vector<camitk::Component *> *);

    /** create a new load by asking the user for the load type.
     *  @return a new load of type choose by the user or NULL if user cancelled
     */
    Load* createNewLoad();

    /// let user play with a current load
    void editLoad();

    /// update the null displacement display
    void updateND();

    /// my load manager
    LoadsManager * myLM;

    /// local copy of the loads
    Loads *loads;

    /// the currently edited load
    Load * editedLoad;

    /// the initial bg color
    QColor bgColor;

    /// the ui dialog designed in qtdesigner
    Ui::LoadsEditor ui;
};

#endif
