/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DECORATION_H
#define DECORATION_H

#include <Component.h>


/// abstract class representing a decoration added to a DC
class Decoration {
public:
    ///
    Decoration(camitk::Component *theDC) : dc(theDC) {};

    /// virtual destructor
    virtual ~Decoration() {};

    /// update the position of the geometric object (using the atom's position)
    virtual void update() = 0;

    /// show the geometric object in 3D or not depending on the paramater
    virtual void show(const bool) = 0;

    /// change the color of the geometric object
    virtual void setColor(const double, const double, const double) = 0;

protected:
    /// the data component where the decoration is attached to
    camitk::Component *dc;
};

#endif
