# This module is only to be included when building CamiTK from source!
# It is to be included just BEFORE CamiTKVariables
#
set(CAMITK_PROJECT_NAME "CamiTK")

# Version (major, minor, patch)
set (CAMITK_VER_MAJ "3")
set (CAMITK_VER_MIN "0")
set (CAMITK_VER_NICKNAME "blue")
set (CAMITK_VER_PACKAGE_PAT "2") # patch version for packaging change when appropriate

string(TOLOWER "${CAMITK_PROJECT_NAME}-${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}" CAMITK_SHORT_VERSION_STRING)

# needed to detect internal build
set(CAMITK_INTERNAL_BUILD TRUE CACHE BOOL "Is this a CamiTK build?" FORCE)
mark_as_advanced(CAMITK_INTERNAL_BUILD)

# Package copy the CamiTKVersion.h to the source tree
if(EXISTS ${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h)
  # In packaged source tree, do not get the svn version
  set(CAMITK_VER_PAT ${CAMITK_VER_PACKAGE_PAT}) 
  set(CAMITK_VERSION_STRING "${CAMITK_PROJECT_NAME} ${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}.${CAMITK_VER_PAT}")
else()
  # In svn checkouted source tree.
  find_package(Subversion QUIET)
  if(Subversion_FOUND)    
    Subversion_WC_INFO(${CAMITK_SOURCE_DIR} CAMITK)
    set (CAMITK_VER_PAT "${CAMITK_VER_PACKAGE_PAT}.${CAMITK_WC_REVISION}")
  else(Subversion_FOUND)
    set (CAMITK_VER_PAT "${CAMITK_VER_PACKAGE_PAT}.svn")
  endif(Subversion_FOUND)
  # prepare the file for the camitk package source build
  set(CAMITK_VERSION_STRING "${CAMITK_PROJECT_NAME} ${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}.${CAMITK_VER_PACKAGE_PAT}")  
  configure_file(${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h.in ${CAMITK_BINARY_DIR}/CamiTKPackageVersion.h)
  # create current version string
  set(CAMITK_VERSION_STRING "${CAMITK_PROJECT_NAME} ${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}.${CAMITK_VER_PAT}")
  # now create the correct version header
  configure_file(${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h.in ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h)
endif()

message(STATUS "Welcome to ${CAMITK_VERSION_STRING}, enjoy your compilation!")

include(CamiTKBuild)

