/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <iostream>
#include <Extension.hxx>
#include <Action.hxx>

#include <QString>
#include <QApplication>

#include "LevelWindow.h"
#include "ExtensionGenerator.h"

int main(int argc, char * argv[]) {
    QApplication app(argc, argv);

    if (argc > 1) {
        if (argc == 3) {
            QString xmlFileName(argv[1]);
            QString devDirectoryName(argv[2]);
            std::cout << "xmlFileName: " << xmlFileName.toStdString() << std::endl;
            std::cout << "devDirectoryName: " << devDirectoryName.toStdString() << std::endl;
    
            if ( ! ExtensionGenerator::generateExtensionFiles(xmlFileName, devDirectoryName))
                std::cout << "Could not produce files correctly, sorry...\n" << std::endl;
        }
        else {
            std::cout << "Usage: " << std::endl;
            std::cout << "wizard [options] xmlFileName.xml pathToDevelopmentDirectory" << std::endl;
        }

        return 0;
    }
    else {
        LevelWindow * wizard = new LevelWindow();
        wizard->show();
        return app.exec();
    }
	
}


