/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "RenderingOption.h"


#include <MeshComponent.h>
#include <InteractiveViewer.h>

using namespace camitk;


// --------------- constructor -------------------
RenderingOption::RenderingOption(ActionExtension* extension) : Action(extension) {
    setName("Rendering Option");
    setIcon(QPixmap(":/renderingOption"));
    setDescription("Change the rendering option (surface, wireframe, points, label...).<br>(c)TIMC-IMAG 2003-2012");
    setComponent("MeshComponent");
    setFamily("Basic Mesh");
    addTag("RenderingMode");
    addTag("Label");

    setProperty("Surface", false);
    setProperty("Wireframe", false);
    setProperty("Points", false);
    setProperty("Label", false);
    setProperty("Glyph", false);
}

RenderingOption::~RenderingOption() {
    // do not delete the widget has it might have been used in the ActionViewer (i.e. the ownership might have been taken by the stacked widget)
}

// --------------- getWidget -------------------
QWidget * RenderingOption::getWidget() {

    //-- init the property values using the selection state
    if (getTargets().size() == 1) {
        // only one selected, easy!
        setProperty("Surface", (bool) (getTargets().first()->getRenderingModes() & InterfaceGeometry::Surface));
        setProperty("Wireframe", (bool) (getTargets().first()->getRenderingModes() & InterfaceGeometry::Wireframe));
        setProperty("Points", (bool) (getTargets().first()->getRenderingModes() & InterfaceGeometry::Points));
    }
    else {
        // more than one: they should all have the same rendering mode to set a proper state
        InterfaceGeometry::RenderingModes m = getTargets().first()->getRenderingModes();
        int i = 1;
        while (i < getTargets().size() && (m == getTargets()[i]->getRenderingModes()))
            i++;

        if (i == getTargets().size()) {
            setProperty("Surface", (bool) (m & InterfaceGeometry::Surface));
            setProperty("Wireframe", (bool) (m & InterfaceGeometry::Wireframe));
            setProperty("Points", (bool) (m & InterfaceGeometry::Points) );
        }
    }

    // additional prop visibility
    if (getTargets().size()>0) {
        setProperty("Glyph", (bool) (getTargets().first()->getProp("glyph")->GetVisibility()));
        setProperty("Label", (bool) (getTargets().first()->getProp("label")->GetVisibility()));
    }
    
    return Action::getWidget();
};


// --------------- apply -------------------
Action::ApplyStatus RenderingOption::apply() {
    // get the current rendering mode from the property values
    InterfaceGeometry::RenderingModes m = InterfaceGeometry::None;
    if (property("Surface").toBool())
        m |= InterfaceGeometry::Surface;
    if (property("Wireframe").toBool())
        m |= InterfaceGeometry::Wireframe;
    if (property("Points").toBool())
        m |= InterfaceGeometry::Points;

    // update the rendering mode of selected
    foreach(Component *comp, getTargets()) {
        comp->setRenderingModes(m);
        // set the additional prop visibility
        comp->getProp("glyph")->SetVisibility(property("Glyph").toBool());
        comp->getProp("label")->SetVisibility(property("Label").toBool());
    }

    // refresh the viewers (here only the viewer of the last component, but should be ok)
    getTargets().last()->refresh();
    
    return SUCCESS;

}
