/*
* cairo-dock-keybinder.h
* This file is a part of the Cairo-Dock project
* Login : <ctaf42@localhost.localdomain>
* Started on  Thu Jan 31 03:57:17 2008 Cedric GESTES
* $Id$
*
* Author(s)
*  - Cedric GESTES <ctaf42@gmail.com>
*  - Havoc Pennington
*  - Tim Janik
*
* Copyright : (C) 2008 Cedric GESTES
* E-mail    : see the 'copyright' file.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 3
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* imported from tomboy_key_binder.h
*/


#ifndef __CD_KEY_BINDER_H__
#define __CD_KEY_BINDER_H__

#include <glib/gtypes.h>
#include "cairo-dock-struct.h"
#include "cairo-dock-manager.h"

G_BEGIN_DECLS

/**
*@file cairo-dock-keybinder.h This class contains functions to easily bind a keyboard shortcut to an action. These shortcuts are defined globally in your session, that is to say they will be effective whatever window has the focus.
* Shortcuts are of the form &lt;alt&gt;F1 or &lt;ctrl&gt;&lt;shift&gt;s.
* 
* You bind an action to a shortcut with \ref cd_keybinder_bind, and unbind it with \ref cd_keybinder_unbind.
*/

typedef struct _CairoShortcutsManager CairoShortcutsManager;

#ifndef _MANAGER_DEF_
extern CairoShortcutsManager myShortcutsMgr;
#endif

/// Definition of a callback, called when a shortcut is pressed by the user.
typedef void (* CDBindkeyHandler) (const char *keystring, gpointer user_data);

// params

// manager
struct _CairoShortcutsManager {
	GldiManager mgr;
	gboolean (*bind) (const char *keystring, CDBindkeyHandler handler, gpointer user_data);
	void (*unbind) (const char *keystring, CDBindkeyHandler handler);
	gboolean (*simulate_key_sequence) (const gchar *cKeyString);
	} ;

// signals
typedef enum {
	NB_NOTIFICATIONS_SHORTCUTS
	} CairoShortcutsNotifications;


void cd_keybinder_init (void);  /// merge with init
void cd_keybinder_stop (void);  /// useless

/** Bind a shortcut to an action. Unbind it when you don't want it anymore, or when 'user_data' is freed.
 * @param keystring a shortcut.
 * @param handler callback to register for this shortcut.
 * @param user_data data passed to the callback.
 * @return TRUE if success.
*/
gboolean cd_keybinder_bind (const char           *keystring,
                            CDBindkeyHandler  handler,
                            gpointer              user_data);

/** Unbind a shortcut to an action.
 * @param keystring a shortcut.
 * @param handler the callback that was registered for this shortcut.
*/
void cd_keybinder_unbind   (const char           *keystring,
                            CDBindkeyHandler  handler);

gboolean cd_keybinder_is_modifier (guint keycode);

//guint32 cd_keybinder_get_current_event_time (void);

/** Trigger the given shortcut. It will be as if the user effectively pressed the shortcut on its keyboard. It uses the 'XTest' X extension.
 * @param cKeyString a shortcut.
 * @return TRUE if success.
*/
gboolean cairo_dock_simulate_key_sequence (gchar *cKeyString);


void gldi_register_shortcuts_manager (void);

G_END_DECLS

#endif /* __CD_KEY_BINDER_H__ */

