# -*- coding: utf-8; indent-tabs-mode: t; tab-width: 4 -*-

#  Copyright (C) 2008-2010 by Canonical Ltd
#  Copyright (C) 2012 Koichi Akabe <vbkaisetsu@gmail.com>
# 
#  gLogic is free software: you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
# 
#  gLogic is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#  See the GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License along
#  with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from bzrlib.commands import Command
from bzrlib import config as globalconfig
from bzrlib import branch
from i18n import gettext as _
import oauth2, urlparse
import twitter

from keys import *

class cmd_twitter_auth(Command):
	"""Authenticate to tweet messages on services

	This command gets an access token from services. 
	
	You can choose "twitter" or "identica" as a service. If you authenticated
	with both services, this plugin will tweet to each services.
	"""

	takes_args = ["service?"]

	def auth(self, service_name, request_token_url, access_token_url, authorize_url, consumer_key, consumer_sec):
		consumer = oauth2.Consumer(key=consumer_key, secret=consumer_sec)
		client = oauth2.Client(consumer)
		try:
			r, data = client.request(request_token_url, "GET")
		except Exception:
			print(_("Unable to connect to the twitter server. Please check the internet connection."))
			return
		d = dict(urlparse.parse_qsl(data))
		print(_("Please access to the following address and get pin:"))
		print("%s?oauth_token=%s" % (authorize_url, d["oauth_token"]))
		pin = raw_input(_("PIN code: ").encode("utf-8"))
		if pin == "":
			print(_("Authorization failed!"))
			return
		token = oauth2.Token(d["oauth_token"], d["oauth_token_secret"])
		client = oauth2.Client(consumer, token)
		try:
			r, data = client.request(access_token_url, "POST", body="oauth_verifier=%s" % pin)
		except Exception:
			print(_("Unable to connect to the twitter server. Please check the internet connection."))
			return
		d = dict(urlparse.parse_qsl(data))
		if "oauth_token" in d and "oauth_token_secret" in d:
			gs = globalconfig.GlobalStack()
			gs.set("%s_token_key" % service_name, d["oauth_token"])
			gs.set("%s_token_secret" % service_name, d["oauth_token_secret"])
			print(_("Authorization success!"))
		else:
			print(_("Authorization failed!"))

	def run(self, service="twitter"):

		if service == "twitter":
			self.auth("twitter",
			          "https://api.twitter.com/oauth/request_token",
			          "https://api.twitter.com/oauth/access_token",
			          "https://api.twitter.com/oauth/authorize",
			          twitter_consumer_key,
			          twitter_consumer_sec)

		elif service == "identica":
			self.auth("identica",
			          "https://identi.ca/api/oauth/request_token?oauth_callback=oob",
			          "https://identi.ca/api/oauth/access_token",
			          "https://identi.ca/api/oauth/authorize",
			          identica_consumer_key,
			          identica_consumer_sec)

		else:
			print(_("Unknown service!"))

class cmd_twitter_branchid(Command):
	"""Set a branch id for commit messages

	This plugin tweets the following formatted message:
	  bzr commit: BRANCHID has the new revid: 10: example commit [bzr-tweet]
	
	You can set BRANCHID using this command.
	"""

	takes_args = ["branchid?"]
	
	def run(self, branchid=None):
		
		if branchid is None:
			branchid = raw_input(_("ID: ").encode("utf-8"))
		
		if branchid == "":
			return
		
		cs = branch.Branch.open_containing(u'.')[0].get_config_stack()
		cs.set("twitter_branch_id", branchid)

