package buoy.event;

import buoy.widget.*;
import java.util.*;

/**
 * SelectionChangedEvents are generated by Widgets that allow the user to select part of their contents,
 * whenever the selection changes.
 *
 * @author Peter Eastman
 */

public class SelectionChangedEvent extends EventObject implements WidgetEvent
{
  private Widget widget;
  private boolean inProgress;

  /**
   * Create a SelectionChangedEvent.
   *
   * @param widget     the Widget whose selection has changed
   */
  
  public SelectionChangedEvent(Widget widget)
  {
    this(widget, false);
  }

  /**
   * Create a SelectionChangedEvent.
   *
   * @param widget       the Widget whose selection has changed
   * @param inProgress   specifies whether this event represents a selection change that is still in progress
   */
  
  public SelectionChangedEvent(Widget widget, boolean inProgress)
  {
    super(widget);
    this.widget = widget;
    this.inProgress = inProgress;
  }

  /**
   * Get the Widget which generated this event.
   */
  
  public Widget getWidget()
  {
    return widget;
  }
  
  /**
   * Determine whether this event represents a selection change that is still in progress.  For example,
   * if the user drags the mouse over a list to select multiple items, but has not yet released the
   * mouse button, this method will return true.  An in progress SelectionChangedEvent will always be
   * followed by another one when the selection change is complete.
   */
  
  public boolean isInProgress()
  {
    return inProgress;
  }
}