/***************************************************************************
 *   Copyright (C) 2002 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LISTCUENTASVIEW1_H
#define LISTCUENTASVIEW1_H

#include <QEvent>

#include "postgresiface2.h"
#include "ui_listcuentasbase.h"
#include "pgimportfiles.h"
#include "ficha.h"


class empresa;

/// Presenta un listado del plan contable.
/** Esta pantalla tiene dos modos de funcionamiento, en uno act&uacute;a como selector de
    cuentas y en el otro act&uacute;a como soporte para la edici&oacute;n del plan contable. */
class listcuentasview1 : public Ficha, public Ui_ListCuentasBase, public pgimportfiles {
    Q_OBJECT

public:
    enum edmode
    {
        EditMode = 0,
        SelectMode = 1
    };

private:
    /// La base de datos con la que se trabaja.
    postgresiface2 *conexionbase;
    /// La empresa que ha construido todo el tema.
    empresa *empresaactual;
    int ccuenta, cdesccuenta;
    int cidcuenta, cbloqueada, cnodebe, cnohaber, cregularizacion, cimputacion, ctipocuenta;
    /// Indice para la QListView de la columna que indica el debe actual de la cuenta.
    int cdebe;
    /// Indice para la QListView de la columna que indica el haber actual de la cuenta.
    int chaber;
    int cgrupo;
    /// Indica si se abre para busqueda o para edicion.
    edmode m_modo;
    /// Indica el n&uacute;mero de d&iacute;gitos que tienen por defecto todas las cuentas que se crean.
    unsigned int numdigitos;
    /// El c&oacute;digo de la cuenta que se devuelve.
    QString mdb_codcuenta;
    /// El identificador de la cuenta que se devuelve
    QString mdb_idcuenta;
    QString mdb_desccuenta;

public:
    void selectMode() {
        m_modo = SelectMode;
    };
    void editMode() {
        m_modo = EditMode;
    };
    QString codcuenta() {
        return mdb_codcuenta;
    };
    QString idcuenta() {
        return mdb_idcuenta;
    };
    QString desccuenta() {
        return mdb_desccuenta;
    };

public:
    listcuentasview1(empresa *, QWidget *parent = 0, Qt::WFlags flag = 0, edmode editmode = EditMode);
    ~listcuentasview1();
    int inicializa();
    virtual void on_mui_borrar_clicked();

private:
    void inicializatabla();

private slots:
    virtual void on_ListView1_itemClicked(QTreeWidgetItem *, int);
    virtual void on_ListView1_itemDoubleClicked(QTreeWidgetItem *, int);

public slots:
    virtual void on_tablacuentas_doubleClicked(int, int, int, const QPoint &);
    virtual void on_mui_editar_clicked();
    virtual void on_mui_crear_clicked();
    virtual void on_mui_busqueda_textChanged(const QString &);
    virtual void on_mui_busqueda_editFinished();
    virtual bool eventFilter(QObject *, QEvent *);
    virtual void on_mui_imprimir_clicked();
    virtual void on_mui_exportar_clicked();
    virtual void on_mui_importar_clicked();
    virtual void on_mui_actualizar_clicked() {
        inicializa();
    };

signals:
    void selected(QString);
};

#endif

