/***************************************************************************
 *   Copyright (C) 2004 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "busquedatipoiva.h"
#include "articulolist.h"
#include "company.h"
#include "funcaux.h"


/** Inicializa todos los componentes a NULL para que no haya confusiones sobre
    si un elemento ha sido inicializado o no.
    Hace la conexion del SIGNAL activated con m_activated para tratar el evento.
*/
/**
\param parent
**/
BusquedaTipoIva::BusquedaTipoIva ( QWidget *parent )
        : QComboBox2 ( parent )
{
    _depura ( "BusquedaTipoIva::BusquedaTipoIva", 0 );
    m_cursorcombo = NULL;
    connect ( this, SIGNAL ( activated ( int ) ), this, SLOT ( m_activated ( int ) ) );
    _depura ( "END BusquedaTipoIva::BusquedaTipoIva", 0 );
}


/** Libera la memoria dinamica que se estaba utilizando.
*/
/**
**/
BusquedaTipoIva::~BusquedaTipoIva()
{
    _depura ( "BusquedaTipoIva::~BusquedaTipoIva", 0 );
    if ( m_cursorcombo != NULL ) {
        delete m_cursorcombo;
    } // end if
    _depura ( "END BusquedaTipoIva::~BusquedaTipoIva", 0 );
}


/** Con este metodo se puede indicar al Widget cual es el tipo_iva seleccionado.
    Recarga el cursor de tipo_iva y cuando encuentra uno con el mismo identificador
    que el que se ha pasado por parametro lo establece como elemento seleccionado.
*/
/**
\param idtipo_iva
\returns
**/
void BusquedaTipoIva::setidtipo_iva ( QString idtipo_iva )
{
    _depura ( "BusquedaTipoIva::setidtipo_iva", 0 );
    if ( m_cursorcombo != NULL ) {
        delete m_cursorcombo;
    } // end if
    m_cursorcombo = empresaBase() ->cargacursor ( "SELECT * FROM tipo_iva" );
    /// Tratamos el caso en que no se haya devuelto nada.
    if ( m_cursorcombo == NULL ) return;
    int i = 0;
    int i1 = 0;
    clear();
    addItem ( "--" );
    while ( !m_cursorcombo->eof() ) {
        i ++;
        if ( m_cursorcombo->valor ( "idtipo_iva" ) == idtipo_iva ) {
            i1 = i;
        } // end if
        addItem ( m_cursorcombo->valor ( "desctipo_iva" ) );
        m_cursorcombo->siguienteregistro();
    } // end while
    setCurrentIndex ( i1 );
    _depura ( "END BusquedaTipoIva::setidtipo_iva", 0 );
}


///
/**
\param idtipo_iva
**/
void BusquedaTipoIva::setValorCampo ( QString idtipo_iva )
{
    _depura ( "BusquedaTipoIva::setValorCampo", 0 );
    setidtipo_iva ( idtipo_iva );
    _depura ( "END BusquedaTipoIva::setValorCampo", 0 );
}


/** Devuelve el identificador del tipo_iva seleccionado
**/
/**
\return
**/
QString BusquedaTipoIva::idtipo_iva()
{
    _depura ( "BusquedaTipoIva::idtipo_iva", 0 );
    _depura ( "END BusquedaTipoIva::idtipo_iva", 0 );
    /// Como puede haber habido un error con la base de datos debemos tratar dicho caso.
    if ( !m_cursorcombo ) return "0";
    return m_cursorcombo->valor ( "idtipo_iva", currentIndex() - 1 );
}

/** Devuelve el identificador del tipo_iva seleccionado
**/
/**
\return
**/
QString BusquedaTipoIva::valorCampo()
{
    _depura ( "BusquedaTipoIva::valorCampo", 0 );
    return idtipo_iva();
    _depura ( "END BusquedaTipoIva::valorCampo", 0 );
}


/** SLOT que responde a la activacion de un elemento en el QComboBox y que hace que se emita el SIGNAL valueChanged
**/
/**
\param index
**/
void BusquedaTipoIva::m_activated ( int index )
{
    _depura ( "BusquedaTipoIva::m_activated", 0 );
    if ( index > 0 ) {
        emit ( valueChanged ( m_cursorcombo->valor ( "idtipo_iva", index - 1 ) ) );
    } else {
        emit ( valueChanged ( "" ) );
    } // end if
    _depura ( "END BusquedaTipoIva::m_activated", 0 );
}



/// ==================================================================

/** Inicializa todos los componentes del Widget a NULL para que no haya posibles confusiones
    sobre si un elemento ha sido creado o no.
    Conecta el SIGNAL activated() con m_activated() para tratarlo.
*/
/**
\param parent
**/
BusquedaTipoIVADelegate::BusquedaTipoIVADelegate ( QWidget *parent )
        : QComboBox2 ( parent )
{
    _depura ( "BusquedaTipoIVADelegate::BusquedaTipoIVADelegate", 0 );
    m_cursorcombo = NULL;
    setSizeAdjustPolicy ( QComboBox::AdjustToContents );
    connect ( this, SIGNAL ( activated ( int ) ), this, SLOT ( m_activated ( int ) ) );
    _depura ( "END BusquedaTipoIVADelegate::BusquedaTipoIVADelegate", 0 );
}


/** Libera la memoria reservada.
*/
/**
**/
BusquedaTipoIVADelegate::~BusquedaTipoIVADelegate()
{
    _depura ( "BusquedaTipoIVADelegate::~BusquedaTipoIVADelegate", 0 );
    if ( m_cursorcombo != NULL ) {
        delete m_cursorcombo;
    } // end if
    _depura ( "END BusquedaTipoIVADelegate::~BusquedaTipoIVADelegate", 0 );
}


/** Permite indicar al Widget cual es la serie de factura seleccionada por defecto.
    Recarga cursor de serie_factura y cuando encuentra un registro cuyo codigoserie_factura coincide con el pasado
    como parametro lo establece como el registro activo por el comboBox.
*/
/**
\param code
**/
void BusquedaTipoIVADelegate::set ( const QString &cod )
{
    _depura ( "BusquedaTipoIVADelegate::set", 0 );
    int index = 0;
    QString codigo = cod;

    if ( m_cursorcombo != NULL ) {
        delete m_cursorcombo;
    } // end if

    m_cursorcombo = empresaBase() ->cargacursor ( "SELECT desctipo_iva FROM tipo_iva " );
    /// Comprobamos que no haya habido errores
    if ( !m_cursorcombo ) return;

    clear();
    while ( !m_cursorcombo->eof() ) {
        addItem ( m_cursorcombo->valor ( "desctipo_iva" ) );
        m_cursorcombo->siguienteregistro();
        if ( m_cursorcombo->valor ( "desctipo_iva" ) == cod )
            index = m_cursorcombo->regactual();
    } // end while
    setEditText ( cod );
    setCurrentIndex ( index );

    _depura ( "END BusquedaTipoIVADelegate::set", 0 );
}

