# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>
#
# Russian translation: Vitaly Fedrushkov <fedrushkov@users.sourceforge.net>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'любая',
    blacklisted => '(в черном списке)',
    checking_for => 'Проверка',
    checking_dbd      => 'Проверка установленных модулей Perl DBD...',
    checking_optional => 'Следующие модули Perl рекомендуются:',
    checking_modules  => 'Проверка модулей Perl...',
    done => 'Готово.',
    header => "* Bugzilla ##bz_ver## на perl ##perl_ver##\n"
            . "* Запущена на ##os_name## ##os_ver##",
    install_all => <<EOT,

Попробуйте установить все требуемые и рекомендуемые модули одной
командой:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
ВНИМАНИЕ: Некоторые данные в поле ##table##.##column## длинней чем
размер поля в текущей версии (##max_length## символов). Данные, которые следует
перечислены ниже (сначала значение кода ##id_column##, затем 
значение поля ##column##, которое следует исправить):

EOT
    install_module => 'Установка модуля ##module## версии ##version##...',
    max_allowed_packet => <<EOT,
ВНИМАНИЕ: Установите значение параметра max_allowed_packet сервера MySQL
не менее ##needed##. Текущее значение -- ##current##.
Параметр настраивается в секции [mysqld] файла конфигурации MySQL.
EOT
    module_found => "найден v##ver##",
    module_not_found => "не найден",
    module_ok => 'ОК',
    module_unknown_version => "найдена неизвестная версия",
    template_precompile   => "Компиляция шаблонов...",
    template_removing_dir => "Удаление скомпилированных шаблонов...",
);

1;
