# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'tout',
    blacklisted => '(liste noire)',
    checking_for => 'Vérification de',
    checking_dbd      => 'Vérification des modules Perl DBD disponibles…',
    checking_optional => 'Les modules Perl suivants sont optionnels :',
    checking_modules  => 'Vérification des modules Perl…',
    done => 'terminé.',
    header => "* Bugzilla ##bz_ver## avec Perl ##perl_ver##\n"
            . "* sur ##os_name## ##os_ver##",
    install_all => <<EOT,

Pour essayer d'installer automatiquement chaque module obligatoire et optionnel
en une seule commande, exécutez :

  ##perl## install-module.pl --all

EOT
    install_data_too_long   => <<EOT,
ATTENTION : Certaines données dans la colonne ##table##.##column## dépassent la nouvelle longueur
limite de ##max_length## caractères. Les données devant être corrigées sont indiquées ci-dessous,
avec la valeur de la colonne ##id_column## d'abord puis la valeur de la colonne ##column## devant
être corrigées :

EOT
    install_module => 'Installation de ##module## version ##version##…',
    max_allowed_packet => <<EOT,
ATTENTION : Vous devez définir le paramètre max_allowed_packet dans votre
configuration MySQL à au moins ##needed##. Actuellement, il est défini à ##current##.
Vous pouvez définir ce paramètre dans la section [mysqld] de votre fichier de
configuration MySQL.
EOT
    module_found => "v##ver## trouvé",
    module_not_found => "non trouvé",
    module_ok => 'ok',
    module_unknown_version => "version inconnue trouvée",
    template_precompile   => "Précompilation des modèles…",
    template_removing_dir => "Suppression des modèles compilés existants…",
);

1;
