#!/usr/bin/env python

import glob
import os
import threading
import Queue
import time

from bugHelper.config import Config

def bughelper_worker():
    while True:
	try:
	    arg = q.get(block=False)
	except Queue.Empty:
	    break
	else:
	    os.system(arg)

if __name__ == "__main__":
    c = Config("~/.bughelper/config")
    try:
        os.makedirs(".prepare")
    except:
        pass

    # Create queue
    q = Queue.Queue()
 
    # Begin adding work to the queue
    for cluefile in glob.glob("%s/*.info" % c.packages_dir):
	packagename = os.path.basename(cluefile).split(".info")[0]
        q.put("bughelper -AU -p %s --verbose 2 --format=html > .prepare/%s.html && mv .prepare/%s.html ." %
		(packagename, packagename, packagename))
    q.put("bughelper -AH -l https://bugs.launchpad.net/ubuntu/+bugs?field.has_no_package=on --verbose 2 --format=html > .prepare/general.html && mv .prepare/general.html .")
    
    # Start a pool of 5 workers
    pool = []
    for i in range(5):
        t = threading.Thread(target=bughelper_worker, name='worker %i' % (i+1))
        pool.append(t)
        t.start()
    # Wait for the threads to finish
    for t in pool:
        t.join()
