# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade

import bt_exceptions
from config import btstype
from config import packages
from config.config import Config
from dlg_package import dlg_package
from pkg_view import pkg_view
from msg_exception import errorhandler

class dlg_config:
    """Configuration dialog related methods"""

    @errorhandler
    def __init__(self, glade_path):
        self.glade_path = glade_path
        self.xml = gtk.glade.XML(glade_path + "dlg_config.glade")
        self.xml.signal_autoconnect(self)
        self.dialog = self.xml.get_widget("dlg_config")

        self.cfg = Config()

        entry_soap_address = self.xml.get_widget("entry_soap_address")
        entry_soap_address.set_text(self.cfg.get_soap_address())

        entry_soap_namespace = self.xml.get_widget("entry_soap_namespace")
        entry_soap_namespace.set_text(self.cfg.get_soap_namespace())

        entry_soap_users = self.xml.get_widget("entry_soap_users")
        entry_soap_users.set_text(", ".join(self.cfg.get_soap_users()))

        entry_html_address = self.xml.get_widget("entry_html_address")
        entry_html_address.set_text(self.cfg.get_html_address())

        entry_html_users = self.xml.get_widget("entry_html_users")
        entry_html_users.set_text(", ".join(self.cfg.get_html_users()))

        if self.cfg.get_bts_method() == "soap":
            self.xml.get_widget("rb_soap").set_active(True)
        elif self.cfg.get_bts_method() == "html":
            self.xml.get_widget("rb_html").set_active(True)

        self.tv_packages = pkg_view(self.xml)

    @errorhandler
    def show(self):
        self.dialog.show_all()

    @errorhandler
    def ok(self, object=None):
        entry_soap_address = self.xml.get_widget("entry_soap_address")
        self.cfg.set_soap_address(entry_soap_address.get_text())

        entry_soap_namespace = self.xml.get_widget("entry_soap_namespace")
        self.cfg.set_soap_namespace(entry_soap_namespace.get_text())

        entry_soap_users = self.xml.get_widget("entry_soap_users")
        self.cfg.set_soap_users(entry_soap_users.get_text().split(", "))

        entry_html_address = self.xml.get_widget("entry_html_address")
        self.cfg.set_html_address(entry_html_address.get_text())

        entry_html_users = self.xml.get_widget("entry_html_users")
        self.cfg.set_html_users(entry_html_users.get_text().split(", "))

        rb_default = self.xml.get_widget("rb_default")
        rb_soap = self.xml.get_widget("rb_soap")

        if rb_default.get_active():
            self.cfg.set_bts_method("default")
        elif rb_soap.get_active():
            self.cfg.set_bts_method("soap")
        else:
            self.cfg.set_bts_method("html")

        self.cfg.write()
        self.close()

    @errorhandler
    def close(self, object=None):
        self.dialog.destroy()

    @errorhandler
    def pkg_del(self, object=None):
        for pkg in self.tv_packages.get_selection():
            packages.remove(pkg.get_package())
        self.tv_packages.load()

    @errorhandler
    def pkg_add(self, object=None):
        dlg = dlg_package(self.glade_path)
        if dlg.run() == dlg.RESPONSE_OK:
            packages.set(dlg.get_package(), dlg.get_type(), dlg.get_data())
        dlg.hide()
        self.tv_packages.load()

    @errorhandler
    def pkg_edit(self, object = None):
        pkgs = self.tv_packages.get_selection()
        for pkg in pkgs:
            dlg = dlg_package(self.glade_path)
            dlg.set_package(pkg.get_package())

            if (pkg.get_type() == btstype.BUGZILLA):
                dlg.set_type(btstype.BUGZILLA)
                data = pkg.get_data()
                if data.has_key("server"):
                    dlg.set_bz_server(data["server"])
                if data.has_key("product"):
                    dlg.set_bz_product(data["product"])
                if data.has_key("component"):
                    dlg.set_bz_component(data["component"])
            else:
                raise bt_exceptions.InvalidBTSError("Invalid Upstream BTS")

            if dlg.run() == dlg.RESPONSE_OK:
                packages.set(dlg.get_package(), dlg.get_type(), dlg.get_data())
             
            dlg.hide()
                    
        self.tv_packages.load()


# vim: tabstop=4 expandtab shiftwidth=4
