/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "Settings.h"
#include "Shared.h"
#include <qsettings.h>

//*******************************************************************
// save                                                      PRIVATE
//*******************************************************************
void Settings::save( const QString& in_group, const QString& in_key, const QString& in_data )
{
	QSettings stt;

	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			stt.writeEntry( Shared::DirSep + in_key, in_data );
		stt.endGroup();
	stt.endGroup();	
}
void Settings::save( const QString& in_group, const QString& in_key, const int in_data )
{
	QSettings stt;

	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			stt.writeEntry( Shared::DirSep + in_key, in_data );
		stt.endGroup();
	stt.endGroup();	
}
void Settings::save( const QString& in_group, const QString& in_key, const QStringList& in_data )
{
	QSettings stt;

	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			stt.writeEntry( Shared::DirSep + in_key, in_data );
		stt.endGroup();
	stt.endGroup();	
}
// end of save

//*******************************************************************
// read
//*******************************************************************
bool Settings::read( const QString& in_group, const QString& in_key, QString& out_data )
{
	bool result = FALSE;
	
	QSettings stt;
	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			out_data = stt.readEntry( Shared::DirSep + in_key, Shared::EmptyStr, &result );
		stt.endGroup();
	stt.endGroup();
	
	return result;
}
bool Settings::read( const QString& in_group, const QString& in_key, int& out_data )
{
	bool result = FALSE;
	
	QSettings stt;
	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			out_data = stt.readNumEntry( Shared::DirSep + in_key, 0, &result );
		stt.endGroup();
	stt.endGroup();
	
	return result;
}
void Settings::read( const QString& in_group, const QString& in_key, QStringList& out_data )
{
	QSettings stt;

	stt.beginGroup( Shared::DirSep + Shared::ProgramName );
		stt.beginGroup( Shared::DirSep + in_group );
			out_data = stt.readListEntry( Shared::DirSep + in_key );
		stt.endGroup();
	stt.endGroup();
}
// end of read
