/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "Config.h"
#include "Settings.h"

/*------- local constants:
-------------------------------------------------------------------*/
const QString Config::PanelConfigGroupName = "Panel config";
const QString Config::AppConfigGroup       = "Application";
//.........................................................
const QString Config::LFS_FontKey          = "lfs font";
const QString Config::FTP_FontKey          = "ftp font";
const QString Config::LFS_BkgColorKey      = "lfs background color";
const QString Config::FTP_BkgColorKey      = "ftp background color";
const QString Config::LangKey              = "language";
const QString Config::SelectionModeKey     = "selection mode";
const QString Config::FnDispModeKey        = "function buttons display mode";
const QString Config::FnFontKey            = "function buttons font";
const QString Config::TerminalKey          = "terminal";
const QString Config::ColumnsResizeKey     = "disable columns resize";
//.........................................................
const QString Config::LFS_DefaultFont      = "Sans Serif,9,-1,5,50,0,0,0,0,0";
const QString Config::FTP_DefaultFont      = "Sans Serif,9,-1,5,50,0,0,0,0,0";
const QString Config::FN_DefaultFont       = "Sans Serif,10,-1,5,50,0,0,0,0,0";
const QString Config::LFS_DefaultBkgColor  = "#ffffc8";
const QString Config::FTP_DefaultBkgColor  = "#fdca97";

/*------- local static variables:
-------------------------------------------------------------------*/
Config* Config::d_instance = 0;


//*******************************************************************
// Config                                                CONSTRUCTOR
//*******************************************************************
Config::Config()
{
	refresh();
}
// end of Config

//*******************************************************************
// ~Config                                               CONSTRUCTOR
//*******************************************************************
Config::~Config()
{}
// end of ~Config

//*******************************************************************
// instance                                                   PUBLIC
//*******************************************************************
Config* Config::instance()
{
	if( 0 == d_instance ) {
		d_instance = new Config;
	}
	return d_instance;
}
// end of instance

//*******************************************************************
// refresh                                                    PUBLIC
//*******************************************************************
void Config::refresh()
{
	QString info;

	if( Settings::read( PanelConfigGroupName, LFS_FontKey, info ) ) {
		d_lfs_font.fromString( info );
	}
	else {
		d_lfs_font.fromString( LFS_DefaultFont );
	}
	//........................................................
	if( Settings::read( PanelConfigGroupName, FTP_FontKey, info ) ) {
		d_ftp_font.fromString( info );
	}
	else {
		d_ftp_font.fromString( FTP_DefaultFont );
	}
	//........................................................
	if( Settings::read( PanelConfigGroupName, LFS_BkgColorKey, info ) ) {
		d_lfs_bkg_color.setNamedColor( info );
	}
	else {
		d_lfs_bkg_color.setNamedColor( LFS_DefaultBkgColor );
	}
	//........................................................
	if( Settings::read( PanelConfigGroupName, FTP_BkgColorKey, info ) ) {
		d_ftp_bkg_color.setNamedColor( info );
	}
	else {
		d_ftp_bkg_color.setNamedColor( FTP_DefaultBkgColor );
	}
	//........................................................
	if( FALSE == Settings::read( AppConfigGroup, LangKey, d_lang ) ) {
		d_lang = Lang_EN;
	}
	//........................................................
	if( FALSE == Settings::read( AppConfigGroup, SelectionModeKey, d_selection_mode ) ) {
		d_selection_mode = NC;
	}
	//.........................................................
	if( FALSE == Settings::read( AppConfigGroup, FnDispModeKey, d_fn_disp_mode ) ) {
		d_fn_disp_mode = FULL_DESC;
	}
	//........................................................
	if( Settings::read( AppConfigGroup, FnFontKey, info ) ) {
		d_fn_font.fromString( info );
	}
	else {
		d_fn_font.fromString( FN_DefaultFont );
	}
	//........................................................
	Settings::read( AppConfigGroup, TerminalKey, d_terminal_call );
	Settings::read( PanelConfigGroupName, ColumnsResizeKey, d_disable_columns_resize );
}
// end of refresh
