
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//#define DEBUG

#include <jack/jack.h>

#define BRISTOL_JACK_STARTED 0x0001
#define BRISTOL_JACK_PORTS	16

typedef struct jackDev {
	jack_client_t *handle;
	jack_port_t *jack_out[BRISTOL_JACK_PORTS];
	jack_port_t *jack_in[BRISTOL_JACK_PORTS];
	jack_default_audio_sample_t *outbuf[BRISTOL_JACK_PORTS];
	jack_default_audio_sample_t *inbuf[BRISTOL_JACK_PORTS];
	audioMain *audiomain;
	u_int64_t flags;
	const char **ports;
} jackDev;

