/***************************************************************************
                   iexplore.h  -  IExplore Class Definition
                             -------------------
    begin                : Sun Sep 15 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The IExplore class contains all Microsoft Internet Explorer specific  *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef IEXPLORE_H
#define IEXPLORE_H

#include "browserbk.h"

#include <QDir>

class IExplore : public BrowserBk
{
public:
	IExplore() { m_Root = NULL; }
	virtual ~IExplore() { delete m_Root; }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0);
#ifdef _WIN32
	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);
#endif
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd)
						throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException)
						{ saveBookmarksX(path, root, browserOrd); }
	static BrowserBk *classFactory(void);

protected:
	virtual BkFolder & root(void) { return *m_Root; }

private:
	bool			checkFolderForUrlFiles(const QString &folder, bool recurse=false);
	void			readFolder(const QString &path, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);
	void			readUrlFile(const QFileInfo& fi, BkBookmark &bk) throw(BkException);
	static  void	saveBookmarksX(const QString &path, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);

	BkFolder	*m_Root;
};

#endif  // end of IEXPLORE_H
