#include "config.h"
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <algorithm>
#include <vector>
#include "parse.h"
#include "s_util.h"
#include "sqlapi.h"
#include "db_table.h"
#include "schema_master.h"

analysis_config cfg;

int main(int argc, char **argv) {
   int  i=0;
   
   if (argc != 2) {
     fprintf(stderr,"Usage:\n  insert_analysis_config filename\n");
     exit(1);
   }

   std::ifstream f(argv[1]);
   
   if (!f.is_open()) {
     fprintf(stderr,"File not found!\n");
     exit(1);
   }

   db_change("sah2b@sci_master_tcp");
   
   while (!f.eof()) {
     f >> cfg;
     if (!f.eof()) {
       i++;
       cfg.insert();
       fprintf(stderr, "SQLCODE is %d  last SQLCODE is %d\n", sql_error_code(), sql_last_error_code());
     }
   } 
  
   std::cout << "Found " << i << " analysis configs." << std::endl;
}       
     
