//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.
//

#ifndef _BMP_CC_WIDGETS_HH
#define _BMP_CC_WIDGETS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <gtkmm.h>
#include <libglademm.h>
#include <libsexymm/icon-entry.h>

namespace Bmp
{
  class AnimatedImage
    : public Gtk::Image
  {
    public:
  
      AnimatedImage (BaseObjectType                       *  obj,
                     Glib::RefPtr<Gnome::Glade::Xml> const&  xml)
      : Gtk::Image    (obj)
      , m_pixbufs_pos (m_pixbufs.end())
      , m_run         (false)
      , m_timestep    (1000)
      {}

      virtual ~AnimatedImage ()
      {}

      void
      start ()
      {
        m_lock.lock ();
        m_run = true;
        m_lock.unlock ();
        Glib::signal_timeout().connect (sigc::mem_fun (*this, &Bmp::AnimatedImage::slot_advance), m_timestep);
      }

      void
      stop ()
      {
        m_lock.lock ();
        m_run = false;
        m_lock.unlock ();
      }

      void
      set_timestep (long timestep)
      {
        stop ();
        m_timestep = timestep;
      }

      void
      load_images (std::vector<std::string> const& files)
      {
        stop ();
        m_pixbufs.clear ();
        for (std::vector<std::string>::const_iterator n = files.begin(); n != files.end(); ++n)
        {
          m_pixbufs.push_back (Gdk::Pixbuf::create_from_file (*n));
        }
        m_pixbufs_pos = m_pixbufs.begin();
      }

    private:

      typedef std::vector<Glib::RefPtr<Gdk::Pixbuf> > PixbufV;
      PixbufV m_pixbufs;
      PixbufV::iterator m_pixbufs_pos;
      Glib::Mutex m_lock;
      bool m_run;
      long m_timestep;

      bool
      slot_advance ()
      {
        m_pixbufs_pos++;
        if (m_pixbufs_pos == m_pixbufs.end())
          m_pixbufs_pos = m_pixbufs.begin();

        set (*m_pixbufs_pos);
  
        m_lock.lock ();
        bool run = m_run;
        m_lock.unlock ();
        return run;
      }
    
  };

  class FilenameEntry
    : public Gtk::Entry
  {
    public :

      FilenameEntry (BaseObjectType                       *  obj,
                     Glib::RefPtr<Gnome::Glade::Xml> const&  xml)
      : Gtk::Entry (obj)
      {}

      virtual ~FilenameEntry ()
      {}
             
    protected :

      virtual bool on_focus_in_event (GdkEventFocus * event);
  };

  class Scroll
    : public Gtk::HScale
  {
    public :

      Scroll (BaseObjectType                       *  obj,
              Glib::RefPtr<Gnome::Glade::Xml> const&  xml)

      : Gtk::HScale (obj),
        m_pass      (false) {}
      virtual ~Scroll () {}
             
    protected :

      virtual bool on_event (GdkEvent * event);

    private :

      bool m_pass;
  };
}

#endif //!_BMP_CC_WIDGETS_HH
