//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_BANNER_IMAGE_HH
#define BMP_UI_BANNER_IMAGE_HH

#include <gtkmm/widget.h>
#include <gdkmm/pixbuf.h>

namespace Bmp
{
  namespace UI
  {
    class BannerImage : public Gtk::Widget
    {
    public:

      BannerImage (Glib::RefPtr<Gdk::Pixbuf> const& left,
                   Glib::RefPtr<Gdk::Pixbuf> const& right,
                   Glib::RefPtr<Gdk::Pixbuf> const& center);

      virtual
      ~BannerImage ();

    protected:

      virtual bool
      on_expose_event (GdkEventExpose *event);

      virtual void
      on_size_request (Gtk::Requisition *requisition);

    private:

      Glib::RefPtr<Gdk::Pixbuf> m_left;
      Glib::RefPtr<Gdk::Pixbuf> m_right;
      Glib::RefPtr<Gdk::Pixbuf> m_center;

      int m_max_height;
    };

  } // UI

} // Bmp

#endif // BMP_UI_BANNER_IMAGE_HH
