//  BMP
//  Copyright (C) 2005-2007 BMP development.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <iostream>
#include <gtkmm.h>
#include <glibmm/i18n.h>
#include <libglademm.h>
#include <boost/format.hpp>
#include "paths.hh"
#include "dialog-simple-progress.hh"
#include "ui-tools.hh"
using namespace Gtk;

namespace
{
  static boost::format progress_f ("%llu / %llu");
}

namespace Bmp
{
      SimpleProgress*
      SimpleProgress::create ()
      {
        char const* path = BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-simple-progress.glade";
        Glib::RefPtr<Gnome::Glade::Xml> xml = Gnome::Glade::Xml::create (path);
        SimpleProgress* p = 0;
        xml->get_widget_derived ("dialog-simple-progress", p);
        return p;
      }

      SimpleProgress::SimpleProgress (BaseObjectType                       *  obj,
                                      Glib::RefPtr<Gnome::Glade::Xml> const&  xml)
      : Dialog      (obj)
      , m_ref_xml   (xml)
      , m_canceled  (0)
      {
        set_modal (true);

        Util::window_set_icon_list (*this, "player");

        m_ref_xml->get_widget("progressbar", m_progress);
        m_progress->set_fraction (0.);
        m_progress->set_text ("");
  
        dynamic_cast <Button *> (m_ref_xml->get_widget ("cancel"))->signal_clicked ().connect
          (sigc::mem_fun (*this, &SimpleProgress::on_cancel));
      }

      void
      SimpleProgress::enable_cancel ()
      {
        set_response_sensitive (GTK_RESPONSE_CANCEL);
      }

      bool
      SimpleProgress::on_delete_event (GdkEventAny* G_GNUC_UNUSED)
      {
        m_canceled = true;
        s_cancel_.emit ();
        return true;
      }

      void
      SimpleProgress::on_cancel ()
      {
        m_canceled = true;
        s_cancel_.emit ();
      }

      bool 
      SimpleProgress::canceled () const
      {
        return m_canceled;
      }

      void
      SimpleProgress::set_label (Glib::ustring const& title)
      {
        dynamic_cast <Label *> (m_ref_xml->get_widget ("progress-label"))->set_markup (title);
        while (gtk_events_pending()) gtk_main_iteration ();
      }

      void
      SimpleProgress::percentage (double p)
      {
        static boost::format
          percent_f ("%u%%");

        m_progress->set_fraction (p);
        m_progress->set_text ((percent_f % ((unsigned int)(p*100))).str()); 
        while (gtk_events_pending()) gtk_main_iteration ();
      }

      void
      SimpleProgress::step (guint64 n_items, guint64 nth_item)
      {
        m_progress->set_fraction ((nth_item*1.)/(n_items*1.));
        m_progress->set_text ((progress_f % nth_item % n_items).str());
        while (gtk_events_pending()) gtk_main_iteration ();
      }

      void
      SimpleProgress::done (bool wait_for_close)
      {
        m_progress->set_fraction (1.);
        if (wait_for_close)
        {
          set_response_sensitive (RESPONSE_CLOSE, true);
          Dialog::run ();
        }
      }
}
