#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <taglib/fileref.h>
// Plugin-specific include
#include "resolver.h"
#include "modfile.h"
#include "modtag.h"

#include "bmp/types/types-basic.hh"
#include "bmp/types/types-library.hh"
#include "bmp/library-ops.hh"

extern "C" int  _plugin_has_accessors;
int _plugin_has_accessors = 1;

extern "C" int  _plugin_version;
int _plugin_version = PLUGIN_VERSION;

extern "C" const char ** _mimetypes ()
{
  static const char * _types[] =
  {
    "audio/x-mod",
    NULL
  };
  return _types;
}

using namespace Bmp;
using namespace TagLib;
using namespace Glib;

extern "C" bool _get (std::string const& filename, DB::Row & row)  
{
  MOD::File opfile (filename.c_str());  

  row.insert (std::make_pair ("title", opfile.MODTag()->title().to8Bit(true)));
  row.insert (std::make_pair ("genre", opfile.MODTag()->genre().to8Bit(true)));

  return true;
}
static void _plugin_init (void) __attribute__((constructor));

static void _plugin_init (void)
{
  TagLib::FileRef::addFileTypeResolver(new MODFileTypeResolver);
}
