//  BMPx - The Dumb Music Player
//  Copyright (C) 2003-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_TYPES_HH
#define BMP_UI_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#ifdef HAVE_TR1
#include<tr1/unordered_map>
#endif // HAVE_TR1

#include <string>
#include <glibmm.h>
#include <gtkmm.h>

#include "bmp/types/types-library.hh"

typedef Glib::RefPtr<Gdk::Pixbuf> RefPixbuf;

namespace Bmp
{
  typedef std::set<Gtk::TreeIter> IterSet;

  typedef std::map<UID, IterSet>          UidIterSetMap;
  typedef std::map<UID, Gtk::TreeIter>    UidIterMap;

  typedef std::vector <Gtk::TreePath>         PathV;
  typedef std::vector <Gtk::TreeRowReference> ReferenceV;
  typedef std::vector <Gtk::TreeIter>         IterV;

  typedef IterSet::iterator       IterSetIter;
  typedef UidIterSetMap::iterator UidIterSetMapIter;
  typedef UidIterMap::iterator    UidIterMapIter;
  typedef PathV::iterator      PathVIter;
  typedef ReferenceV::iterator ReferenceVIter;
  typedef IterV::iterator      IterVIter;

  typedef Gtk::TreeModelColumn<Track>         ColumnTrack;
  typedef Gtk::TreeModelColumn<UID>           ColumnUID;
  typedef Gtk::TreeModelColumn<Glib::ustring> ColumnString;
  typedef Gtk::TreeModelColumn<bool>          ColumnBool;

  typedef std::vector<Gtk::TargetEntry>       DNDEntries;

  enum BmpMetadataParseFlags
  {
    PARSE_FLAGS_IMAGE   = 1 << 0,
    PARSE_FLAGS_TEXT    = 1 << 1,
    PARSE_FLAGS_ALL     = 3,
  };

  class TrackMetadata
    : public Bmp::Track
  {
    public:

      Glib::RefPtr <Gdk::Pixbuf> image;
      bool image_known;

      TrackMetadata (Bmp::Track const& track) 
        : Bmp::Track (track)
        , image (Glib::RefPtr<Gdk::Pixbuf>(0))
        , image_known (false)
          {}

      TrackMetadata ()  
        : image (Glib::RefPtr<Gdk::Pixbuf>(0))
        , image_known (false)
          {}

      virtual ~TrackMetadata () {}
  };
}
#endif // !BMP_UI_TYPES_HH
