
 /*
stream received on pressing 'play'
 00 tlabel, ptype, cr, ipid
 11 pid1
 0e pid0
 00 ctype control
 48 panel subunit/unit 0
 7c passthrough opcode
 44 play
 00 data length is 0

reply should be:
 02 tlabel, ptype, cr reply, ipid
 11 pid1
 0e pid0
 09 control accepted
 48 panel subunit/unit 0
 7c passthrough opcode
 44 play
 00 data length is 0

play-> 44, c4
next-> 4b, cb
prev-> 4c, cc

*/

struct avctp_header {
	uint8_t ipid:1;
	uint8_t cr:1;
	uint8_t packet_type:2;
	uint8_t transaction_label:4;
	uint16_t pid;
} __attribute__ ((packed));

struct avc_frame {
	struct avctp_header header;
	uint8_t ctype:4;
	uint8_t zeroes:4;
	uint8_t subunit_id:3;
	uint8_t subunit_type:5;
	uint8_t opcode;
	uint8_t operand0;
	uint8_t operand1;
} __attribute__ ((packed));

// avrcp p. 49 for operand examples unit/subunit/passthrough

// Message types
#define AVCTP_COMMAND_FRAME 0
#define AVCTP_RESPONSE_FRAME 1

// Packet types
#define PACKET_TYPE_SINGLE 0
#define PACKET_TYPE_START 1
#define PACKET_TYPE_CONTINUE 2
#define PACKET_TYPE_END 3

// AVRCP profile pid
#define AVRCP_PID 0x0e11

// we define the psm
#define L2CAP_PSM_AVCTP            0x0017

// ctype entries
#define CTYPE_CONTROL  0x0
#define CTYPE_STATUS   0x1
#define CTYPE_ACCEPTED 0x9
#define CTYPE_STABLE   0xC

// opcodes
#define OP_UNITINFO    0x30
#define OP_SUBUNITINFO 0x31
#define OP_PASSTHROUGH 0x7c

// subunits of interest
#define SUBUNIT_PANEL 9

// operands in passthrough commands
#define VOLUP_OP 0x41
#define VOLDOWN_OP 0x42
#define MUTE_OP 0x43

#define PLAY_OP 0x44
#define STOP_OP 0x45
#define PAUSE_OP 0x46
#define NEXT_OP 0x4b
#define PREV_OP 0x4c

enum
{
	avrcp_select                          = (0x0),
	avrcp_up,
	avrcp_down,
	avrcp_left,
	avrcp_right,
	avrcp_right_up,
	avrcp_right_down,
	avrcp_left_up,
	avrcp_left_down,
	avrcp_root_menu,
	avrcp_setup_menu,
	avrcp_contents_menu,
	avrcp_favourite_menu,
	avrcp_exit,
	/* 0x0e to 0x1f Reserved */
	avrcp_0                               = (0x20),
	avrcp_1,
	avrcp_2,
	avrcp_3,
	avrcp_4,
	avrcp_5,
	avrcp_6,
	avrcp_7,
	avrcp_8,
	avrcp_9,
	avrcp_dot,
	avrcp_enter,
	avrcp_clear,
	/* 0x2d - 0x2f Reserved */
	avrcp_channel_up                      = (0x30),
	avrcp_channel_down,
	avrcp_sound_select,
	avrcp_input_select,
	avrcp_display_information,
	avrcp_help,
	avrcp_page_up,
	avrcp_page_down,
	/* 0x39 - 0x3f Reserved */
	avrcp_power                           = (0x40),
	avrcp_volume_up,
	avrcp_volume_down,
	avrcp_mute,
	avrcp_play,
	avrcp_stop,
	avrcp_pause,
	avrcp_record,
	avrcp_rewind,
	avrcp_fast_forward,
	avrcp_eject,
	avrcp_forward,
	avrcp_backward,
	/* 0x4d - 0x4f Reserved */
	avrcp_angle                           = (0x50),
	avrcp_subpicture,
	/* 0x52 - 0x70 Reserved */
	avrcp_f1                              = (0x71),
	avrcp_f2,
	avrcp_f3,
	avrcp_f4,
	avrcp_f5,
	avrcp_vendor_unique                   = (0x7e)
	/* Ox7f Reserved */
};

 

