/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __ALSA_LIB_H__
#define __ALSA_LIB_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

typedef struct snd_pcm_alsa* LPALSA;

// Global library initialisation
extern void alsa_init( void);
extern void alsa_exit( void);

// Connect to alsa
extern LPALSA alsa_new( char* device, int framerate);
extern void alsa_destroy( LPALSA *alsa);
extern int alsa_state_connect( LPALSA alsa);
extern void alsa_state_disconnect( LPALSA alsa);
extern int alsa_is_connecting( LPALSA alsa);

// transfers data
extern int alsa_transfer_raw( LPALSA alsa, const char* pcm_buffer, int pcm_buffer_size);

#endif
