/*
 * $Id: BLI_math.h 34966 2011-02-18 13:58:08Z jesterking $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: some of this file.
 *
 * ***** END GPL LICENSE BLOCK *****
 * */

#ifndef BLI_MATH_H
#define BLI_MATH_H

/** \file BLI_math.h
 *  \ingroup bli
 *  \section mathabbrev Abbreviations
 *
 *  - fl = float
 *  - db = double
 *  - v2 = vec2 = vector 2
 *  - v3 = vec3 = vector 3
 *  - v4 = vec4 = vector 4
 *  - qt = quat = quaternion
 *  - dq = dquat = dual quaternion
 *  - m2 = mat2 = matrix 2x2
 *  - m3 = mat3 = matrix 3x3
 *  - m4 = mat4 = matrix 4x4
 *  - eul = euler rotation
 *  - eulO = euler with order
 *
 *  \section mathvarnames Variable Names
 *
 *  - f = single value
 *  - a, b, c = vectors
 *  - r = result vector
 *  - A, B, C = matrices
 *  - R = result matrix
 */

#include "BLI_math_base.h"
#include "BLI_math_color.h"
#include "BLI_math_matrix.h"
#include "BLI_math_rotation.h"
#include "BLI_math_vector.h"
#include "BLI_math_geom.h"

#endif /* BLI_MATH_H */

